"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderColumnBars = exports.renderColumnTickLabels = void 0;
var bar_1 = require("./glyphs/bar");
var boxplot_1 = require("./glyphs/boxplot");
var textOffset = 0.35;
var showMissingValuesAsZero = false;
var renderColumnTickLabels = function (ctx, config, fadeOutPixelWidth, emWidth, getPixelX, labelFormat, minorLabelFormat, textNestLevelRowLimited, cartesianWidth, binStartList) {
    var e_1, _a;
    try {
        for (var binStartList_1 = __values(binStartList), binStartList_1_1 = binStartList_1.next(); !binStartList_1_1.done; binStartList_1_1 = binStartList_1.next()) {
            var _b = binStartList_1_1.value, minimum = _b.minimum, supremum = _b.supremum;
            var text = textNestLevelRowLimited === config.maxLabelRowCount
                ? labelFormat(minimum * 1000)
                : minorLabelFormat(minimum * 1000);
            if (text.length <= 0)
                continue;
            var pixelX = Math.max(0, getPixelX(minimum));
            var textX = pixelX + config.horizontalPixelOffset;
            var y = config.verticalPixelOffset + (textNestLevelRowLimited - 1) * config.rowPixelPitch;
            var maxWidth = getPixelX(supremum) - config.horizontalPixelOffset;
            var leftShortening = maxWidth >= cartesianWidth
                ? 0
                : Math.max(0, ctx.measureText(text).width + config.horizontalPixelOffset - maxWidth);
            var rightShortening = textX + Math.min(maxWidth, text.length * emWidth) < cartesianWidth
                ? 0
                : Math.max(0, textX + ctx.measureText(text).width - cartesianWidth);
            var maxWidthRight = Math.max(0, cartesianWidth - textX);
            var clipLeft = config.clipLeft && leftShortening > 0;
            var clipRight = config.clipRight && rightShortening > 0;
            if (clipLeft) {
                ctx.save();
                ctx.beginPath();
                ctx.rect(config.horizontalPixelOffset, y - textOffset * config.rowPixelPitch, maxWidth, config.rowPixelPitch);
                ctx.clip();
            }
            if (clipRight) {
                ctx.save();
                ctx.beginPath();
                ctx.rect(textX, y - textOffset * config.rowPixelPitch, maxWidthRight, config.rowPixelPitch);
                ctx.clip();
            }
            ctx.fillStyle = config.a11y.contrast === 'low' ? config.subduedFontColor : config.defaultFontColor;
            ctx.fillText(text, textX - leftShortening, y);
            if (clipRight) {
                var _c = config.backgroundColor, r = _c.r, g = _c.g, b = _c.b;
                var fadeOutRight = ctx.createLinearGradient(textX, 0, textX + maxWidthRight, 0);
                fadeOutRight.addColorStop(0, "rgba(".concat(r, ",").concat(g, ",").concat(b, ",0)"));
                fadeOutRight.addColorStop(maxWidthRight <= 0 ? 0.5 : Math.max(0, 1 - fadeOutPixelWidth / maxWidthRight), "rgba(".concat(r, ",").concat(g, ",").concat(b, ",0)"));
                fadeOutRight.addColorStop(1, "rgba(".concat(r, ",").concat(g, ",").concat(b, ",1)"));
                ctx.fillStyle = fadeOutRight;
                ctx.fill();
                ctx.restore();
            }
            if (clipLeft) {
                var _d = config.backgroundColor, r = _d.r, g = _d.g, b = _d.b;
                var fadeOutLeft = ctx.createLinearGradient(0, 0, maxWidth, 0);
                fadeOutLeft.addColorStop(0, "rgba(".concat(r, ",").concat(g, ",").concat(b, ",1)"));
                fadeOutLeft.addColorStop(maxWidth <= 0 ? 0.5 : Math.min(1, fadeOutPixelWidth / maxWidth), "rgba(".concat(r, ",").concat(g, ",").concat(b, ",0)"));
                fadeOutLeft.addColorStop(1, "rgba(".concat(r, ",").concat(g, ",").concat(b, ",0)"));
                ctx.fillStyle = fadeOutLeft;
                ctx.fill();
                ctx.restore();
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (binStartList_1_1 && !binStartList_1_1.done && (_a = binStartList_1.return)) _a.call(binStartList_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
};
exports.renderColumnTickLabels = renderColumnTickLabels;
var renderColumnBars = function (ctx, getPixelX, cartesianWidth, cartesianHeight, barPad, rows, yUnitScale, barChroma, barFillAlpha, timeBins) {
    var e_2, _a;
    var _loop_1 = function (minimum, supremum) {
        var foundRow = rows.find(function (r) { return minimum * 1000 <= r.epochMs && r.epochMs < supremum * 1000; });
        if (!foundRow && !showMissingValuesAsZero)
            return "continue";
        var fullBarPixelX = getPixelX(minimum);
        var barMaxWidthPixels = getPixelX(supremum) - fullBarPixelX - 2 * barPad;
        var pixelX = Math.max(0, fullBarPixelX);
        var leftShortfall = Math.abs(pixelX - fullBarPixelX);
        var leftOpacityMultiplier = leftShortfall ? 1 - Math.max(0, Math.min(1, leftShortfall / barMaxWidthPixels)) : 1;
        var barX = pixelX + barPad;
        var rightShortfall = Math.max(0, barX + barMaxWidthPixels - cartesianWidth);
        var maxBarHeight = cartesianHeight;
        var barWidthPixels = barMaxWidthPixels - rightShortfall;
        var rightOpacityMultiplier = rightShortfall
            ? 1 - Math.max(0, Math.min(1, rightShortfall / barMaxWidthPixels))
            : 1;
        var r = barChroma.r, g = barChroma.g, b = barChroma.b;
        var maxOpacity = barFillAlpha;
        var opacityMultiplier = leftOpacityMultiplier * rightOpacityMultiplier;
        var opacity = maxOpacity * opacityMultiplier;
        var opacityDependentLineThickness = opacityMultiplier === 1 ? 1 : Math.sqrt(opacityMultiplier);
        ctx.save();
        if (foundRow === null || foundRow === void 0 ? void 0 : foundRow.boxplot) {
            (0, boxplot_1.renderBoxplotGlyph)(ctx, barMaxWidthPixels, barX, leftShortfall, foundRow, maxBarHeight, yUnitScale, opacityMultiplier, r, g, b, maxOpacity);
        }
        else {
            (0, bar_1.renderBarGlyph)(ctx, barWidthPixels, leftShortfall, maxBarHeight, yUnitScale, foundRow, r, g, b, opacity, barX, opacityDependentLineThickness);
        }
        ctx.restore();
    };
    try {
        for (var timeBins_1 = __values(timeBins), timeBins_1_1 = timeBins_1.next(); !timeBins_1_1.done; timeBins_1_1 = timeBins_1.next()) {
            var _b = timeBins_1_1.value, minimum = _b.minimum, supremum = _b.supremum;
            _loop_1(minimum, supremum);
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (timeBins_1_1 && !timeBins_1_1.done && (_a = timeBins_1.return)) _a.call(timeBins_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
};
exports.renderColumnBars = renderColumnBars;
//# sourceMappingURL=column.js.map