"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderCartesian = void 0;
var raster_1 = require("./raster");
var multilayer_ticks_1 = require("../../../xy_chart/axes/timeslip/multilayer_ticks");
var scale_1 = require("../../projections/scale");
var renderCartesian = function (ctx, config, dataState, defaultMinorTickLabelFormat, emWidth, fadeOutPixelWidth, defaultLabelFormat, yTickNumberFormatter, rasterSelector, cartesianWidth, cartesianHeight, _a, yUnitScale, niceTicks) {
    var _b, _c;
    var domainFrom = _a.domainFrom, domainTo = _a.domainTo;
    ctx.textBaseline = 'top';
    ctx.fillStyle = config.defaultFontColor;
    ctx.font = config.cssFontShorthand;
    ctx.textAlign = 'left';
    var getPixelX = (0, scale_1.makeLinearScale)(domainFrom, domainTo, 0, cartesianWidth);
    var layers = rasterSelector((0, multilayer_ticks_1.notTooDense)(domainFrom, domainTo, 0, cartesianWidth, multilayer_ticks_1.MAX_TIME_TICK_COUNT));
    var loHi = layers.reduce((0, raster_1.renderRaster)(ctx, config, dataState, fadeOutPixelWidth, emWidth, defaultMinorTickLabelFormat, defaultLabelFormat, yTickNumberFormatter, domainFrom, domainTo, getPixelX, cartesianWidth, cartesianHeight, niceTicks, yUnitScale, layers), { lo: null, hi: null, unitBarMaxWidthPixelsSum: 0, unitBarMaxWidthPixelsCount: 0 });
    var finestLayer = layers[0];
    return {
        lo: loHi.lo,
        hi: loHi.hi,
        binUnit: (_b = finestLayer === null || finestLayer === void 0 ? void 0 : finestLayer.unit) !== null && _b !== void 0 ? _b : 'millisecond',
        binUnitCount: (_c = finestLayer === null || finestLayer === void 0 ? void 0 : finestLayer.unitMultiplier) !== null && _c !== void 0 ? _c : 1,
        unitBarMaxWidthPixels: loHi.unitBarMaxWidthPixelsSum / loHi.unitBarMaxWidthPixelsCount,
    };
};
exports.renderCartesian = renderCartesian;
//# sourceMappingURL=cartesian.js.map