"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTimeUnitAnnotation = void 0;
var predicate_1 = require("../../../../../common/predicate");
var locale_translations_1 = require("../../../../xy_chart/axes/timeslip/locale_translations");
var multilayer_ticks_1 = require("../../../../xy_chart/axes/timeslip/multilayer_ticks");
function renderTimeUnitAnnotation(ctx, config, binUnitCount, binUnit, chartTopFontSize, yOffset, unitBarMaxWidthPixels) {
    var locale = (0, predicate_1.hasKey)(locale_translations_1.LOCALE_TRANSLATIONS, config.locale)
        ? config.locale
        : multilayer_ticks_1.DEFAULT_LOCALE;
    var unitBarY = yOffset - chartTopFontSize * 1.7;
    ctx.save();
    ctx.textBaseline = 'bottom';
    ctx.textAlign = 'left';
    ctx.font = config.monospacedFontShorthand;
    ctx.fillStyle = config.a11y.contrast === 'low' ? config.subduedFontColor : config.defaultFontColor;
    ctx.fillText("1 ".concat(locale_translations_1.LOCALE_TRANSLATIONS[locale].bar, " = ").concat(binUnitCount, " ").concat(locale_translations_1.LOCALE_TRANSLATIONS[locale][binUnit][binUnitCount === 1 ? 0 : 1]), 0, yOffset);
    ctx.fillRect(0, unitBarY, unitBarMaxWidthPixels, 1);
    ctx.fillRect(0, unitBarY - 3, 1, 7);
    ctx.fillRect(unitBarMaxWidthPixels - 1, unitBarY - 3, 1, 7);
    ctx.restore();
}
exports.renderTimeUnitAnnotation = renderTimeUnitAnnotation;
//# sourceMappingURL=time_unit.js.map