"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTimeExtentAnnotation = void 0;
function renderTimeExtentAnnotation(ctx, config, localeOptions, _a, cartesianWidth, yOffset) {
    var domainFrom = _a.domainFrom, domainTo = _a.domainTo;
    ctx.save();
    ctx.textBaseline = 'bottom';
    ctx.textAlign = 'right';
    ctx.font = config.monospacedFontShorthand;
    ctx.fillStyle = config.subduedFontColor;
    ctx.fillText("".concat(new Date(domainFrom * 1000).toLocaleString(config.locale, localeOptions), " \u2014 ").concat(new Date(domainTo * 1000).toLocaleString(config.locale, localeOptions)), cartesianWidth, yOffset);
    ctx.restore();
}
exports.renderTimeExtentAnnotation = renderTimeExtentAnnotation;
//# sourceMappingURL=time_extent.js.map