"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.keyPanVelocityDivisor = exports.keyZoomVelocityDivisor = exports.wheelZoomVelocity = exports.wheelPanVelocity = exports.backgroundFillStyle = exports.chartTopFontSize = exports.fadeOutPixelWidth = exports.defaultMinorTickLabelFormat = exports.defaultLabelFormat = exports.localeOptions = exports.verticalCartesianAreaPad = exports.horizontalCartesianAreaPad = exports.ZERO_Y_BASE = exports.config = exports.rasterConfig = exports.timeZone = exports.drawCartesianBox = exports.HORIZONTAL_AXIS = void 0;
var time_zone_1 = require("../../../utils/time_zone");
var cached_chrono_1 = require("../../xy_chart/axes/timeslip/chrono/cached_chrono");
var multilayer_ticks_1 = require("../../xy_chart/axes/timeslip/multilayer_ticks");
exports.HORIZONTAL_AXIS = 'continuousTime';
var initialDarkMode = false;
exports.drawCartesianBox = false;
var lineThicknessSteps = [0.5, 0.75, 1, 1, 1, 1.25, 1.25, 1.5, 1.5, 1.75, 1.75, 2, 2, 2, 2, 2];
var lumaSteps = [192, 72, 32, 16, 8, 4, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0];
var smallFontSize = 12;
exports.timeZone = (0, time_zone_1.getValidatedTimeZone)((0, time_zone_1.getZoneFromSpecs)([]));
var themeLight = {
    defaultFontColor: 'black',
    subduedFontColor: '#393939',
    offHourFontColor: 'black',
    weekendFontColor: 'darkred',
    backgroundColor: { r: 255, g: 255, b: 255 },
    lumaSteps: lumaSteps,
};
var themeDark = {
    defaultFontColor: 'white',
    subduedFontColor: 'darkgrey',
    offHourFontColor: 'white',
    weekendFontColor: 'indianred',
    backgroundColor: { r: 0, g: 0, b: 0 },
    lumaSteps: lumaSteps.map(function (l) { return 255 - l; }),
};
exports.rasterConfig = {
    minimumTickPixelDistance: multilayer_ticks_1.MINIMUM_TICK_PIXEL_DISTANCE,
    locale: multilayer_ticks_1.DEFAULT_LOCALE,
};
exports.config = __assign(__assign(__assign({ darkMode: initialDarkMode }, (initialDarkMode ? themeDark : themeLight)), exports.rasterConfig), { sparse: false, implicit: false, maxLabelRowCount: 2, a11y: {
        contrast: 'medium',
    }, numUnit: 'short', barChroma: { r: 96, g: 146, b: 192 }, barFillAlpha: 0.3, lineThicknessSteps: lineThicknessSteps, domainFrom: (0, cached_chrono_1.cachedZonedDateTimeFrom)({ timeZone: exports.timeZone, year: 2002, month: 1, day: 1 })[cached_chrono_1.timeProp.epochSeconds], domainTo: (0, cached_chrono_1.cachedZonedDateTimeFrom)({ timeZone: exports.timeZone, year: 2022, month: 1, day: 1 })[cached_chrono_1.timeProp.epochSeconds], smallFontSize: smallFontSize, cssFontShorthand: "normal normal 100 ".concat(smallFontSize, "px Inter, Helvetica, Arial, sans-serif"), monospacedFontShorthand: "normal normal 100 ".concat(smallFontSize, "px \"Roboto Mono\", Consolas, Menlo, Courier, monospace"), rowPixelPitch: 16, horizontalPixelOffset: 4, verticalPixelOffset: 6, clipLeft: true, clipRight: true, yTickOverhang: 8, yTickGap: 8 });
exports.ZERO_Y_BASE = true;
exports.horizontalCartesianAreaPad = [0.04, 0.04];
exports.verticalCartesianAreaPad = [0.3, 0.12];
exports.localeOptions = {
    hour12: false,
    year: 'numeric',
    month: 'short',
    day: '2-digit',
    hour: '2-digit',
    minute: '2-digit',
    second: '2-digit',
};
var defaultLabelFormatter = new Intl.DateTimeFormat(exports.config.locale, {
    weekday: 'short',
    hour: 'numeric',
    minute: 'numeric',
    timeZone: exports.timeZone,
});
var defaultLabelFormat = function (value) { return defaultLabelFormatter.format(value); };
exports.defaultLabelFormat = defaultLabelFormat;
var defaultMinorTickLabelFormatter = new Intl.DateTimeFormat(exports.config.locale, {
    weekday: 'short',
    hour: 'numeric',
    minute: 'numeric',
    timeZone: exports.timeZone,
});
var defaultMinorTickLabelFormat = function (value) { return defaultMinorTickLabelFormatter.format(value); };
exports.defaultMinorTickLabelFormat = defaultMinorTickLabelFormat;
exports.fadeOutPixelWidth = 12;
exports.chartTopFontSize = exports.config.smallFontSize + 2;
var background = exports.config.backgroundColor;
exports.backgroundFillStyle = "rgba(".concat(background.r, ",").concat(background.g, ",").concat(background.b, ",1)");
exports.wheelPanVelocity = 1;
exports.wheelZoomVelocity = 2;
exports.keyZoomVelocityDivisor = 2;
exports.keyPanVelocityDivisor = 10;
//# sourceMappingURL=config.js.map