"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeLinearScale = exports.getDesiredTickCount = void 0;
var getDesiredTickCount = function (cartesianHeight, fontSize, sparse) {
    var desiredMaxTickCount = Math.floor(cartesianHeight / (3 * fontSize));
    return sparse ? 1 + Math.ceil(Math.pow(desiredMaxTickCount, 0.25)) : 1 + Math.ceil(Math.sqrt(desiredMaxTickCount));
};
exports.getDesiredTickCount = getDesiredTickCount;
var makeLinearScale = function (domainFrom, domainTo, rangeFrom, rangeTo) {
    var domainExtent = domainTo - domainFrom;
    var rangeExtent = rangeTo - rangeFrom;
    var scale = rangeExtent / domainExtent;
    var offset = rangeFrom - scale * domainFrom;
    return function (d) { return offset + scale * d; };
};
exports.makeLinearScale = makeLinearScale;
//# sourceMappingURL=scale.js.map