"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTooltipInfoSelector = void 0;
var geometries_1 = require("./geometries");
var partition_spec_1 = require("./partition_spec");
var picked_shapes_1 = require("./picked_shapes");
var create_selector_1 = require("../../../../state/create_selector");
var picked_shapes_2 = require("../../layout/viewmodel/picked_shapes");
var EMPTY_TOOLTIP = Object.freeze({ header: null, values: [] });
exports.getTooltipInfoSelector = (0, create_selector_1.createCustomCachedSelector)([partition_spec_1.getPartitionSpec, picked_shapes_1.getPickedShapes, geometries_1.partitionMultiGeometries], function (spec, pickedShapes, shapeViewModel) {
    return spec
        ? (0, picked_shapes_2.pickShapesTooltipValues)(pickedShapes, shapeViewModel, spec.valueGetter, spec.valueFormatter, spec.percentFormatter, spec.id)
        : EMPTY_TOOLTIP;
});
//# sourceMappingURL=tooltip.js.map