"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeLegendSelector = void 0;
var geometries_1 = require("./geometries");
var get_partition_specs_1 = require("./get_partition_specs");
var tree_1 = require("./tree");
var color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
var colors_1 = require("../../../../common/colors");
var create_selector_1 = require("../../../../state/create_selector");
var get_legend_config_selector_1 = require("../../../../state/selectors/get_legend_config_selector");
var get_settings_spec_1 = require("../../../../state/selectors/get_settings_spec");
var common_1 = require("../../../../utils/common");
var legend_1 = require("../../../../utils/legend");
var config_types_1 = require("../../layout/types/config_types");
var group_by_rollup_1 = require("../../layout/utils/group_by_rollup");
var viewmodel_1 = require("../../layout/viewmodel/viewmodel");
function compareLegendItemNames(aItem, bItem) {
    return aItem.item.label.localeCompare(bItem.item.label);
}
function compareDescendingLegendItemValues(aItem, bItem) {
    var _a, _b;
    return ((_a = aItem.item.depth) !== null && _a !== void 0 ? _a : -1) - ((_b = bItem.item.depth) !== null && _b !== void 0 ? _b : -1) || bItem.node[group_by_rollup_1.AGGREGATE_KEY] - aItem.node[group_by_rollup_1.AGGREGATE_KEY];
}
exports.computeLegendSelector = (0, create_selector_1.createCustomCachedSelector)([get_settings_spec_1.getSettingsSpecSelector, get_partition_specs_1.getPartitionSpecs, get_legend_config_selector_1.getLegendConfigSelector, geometries_1.partitionMultiGeometries, tree_1.getTrees], function (settings, specs, _a, geometries, trees) {
    var flatLegend = _a.flatLegend, legendMaxDepth = _a.legendMaxDepth, legendPosition = _a.legendPosition;
    var sortingFn = flatLegend && settings.legendSort;
    return trees.flatMap(function (tree) {
        var customSortingFn = sortingFn
            ? function (aItem, bItem) {
                return sortingFn({
                    smAccessorValue: tree.smAccessorValue,
                    specId: aItem.item.seriesIdentifiers[0].specId,
                    key: aItem.item.seriesIdentifiers[0].key,
                }, {
                    smAccessorValue: tree.smAccessorValue,
                    specId: bItem.item.seriesIdentifiers[0].specId,
                    key: bItem.item.seriesIdentifiers[0].key,
                });
            }
            : undefined;
        var useHierarchicalLegend = (0, legend_1.isHierarchicalLegend)(flatLegend, legendPosition);
        var valueFormatter = specs[0].valueFormatter;
        var items = walkTree(specs[0].id, useHierarchicalLegend, valueFormatter, tree.tree, specs[0].layers, 0);
        return items
            .filter(function (d) {
            var _a;
            var depth = (_a = d.item.depth) !== null && _a !== void 0 ? _a : -1;
            if (d.item.childId === group_by_rollup_1.HIERARCHY_ROOT_KEY) {
                return false;
            }
            return depth < legendMaxDepth;
        })
            .sort(customSortingFn !== null && customSortingFn !== void 0 ? customSortingFn : (specs[0].layout === config_types_1.PartitionLayout.waffle
            ? compareDescendingLegendItemValues
            : (0, viewmodel_1.isLinear)(specs[0].layout)
                ? compareLegendItemNames
                : function () { return 0; }))
            .map(function (_a) {
            var item = _a.item;
            return item;
        });
    });
});
function walkTree(specId, useHierarchicalLegend, valueFormatter, tree, layers, depth, uniqueNames, legendItems) {
    var e_1, _a;
    var _b, _c, _d;
    if (uniqueNames === void 0) { uniqueNames = new Set(); }
    if (legendItems === void 0) { legendItems = []; }
    if (tree.length === 0) {
        return legendItems;
    }
    try {
        for (var tree_2 = __values(tree), tree_2_1 = tree_2.next(); !tree_2_1.done; tree_2_1 = tree_2.next()) {
            var _e = __read(tree_2_1.value, 2), key = _e[0], node = _e[1];
            var layer = layers[depth - 1];
            var formatter = (_b = layer === null || layer === void 0 ? void 0 : layer.nodeLabel) !== null && _b !== void 0 ? _b : (function (d) { return "".concat(d); });
            var fill = (_d = (_c = layer === null || layer === void 0 ? void 0 : layer.shape) === null || _c === void 0 ? void 0 : _c.fillColor) !== null && _d !== void 0 ? _d : (0, color_library_wrappers_1.RGBATupleToString)(colors_1.Colors.DarkOpaqueRed.rgba);
            var fillColor = typeof fill === 'function' ? fill(key, node.sortIndex, node, tree) : fill;
            var label = formatter(key);
            var joinedPath = node[group_by_rollup_1.PATH_KEY].map(function (d) { return d.value; }).join('##');
            var uniqueKey = "".concat(depth, "--").concat(joinedPath, "--").concat(label, "--").concat(fillColor, "--").concat(node[group_by_rollup_1.AGGREGATE_KEY]);
            if (!(0, common_1.isNil)(key) && !uniqueNames.has(uniqueKey)) {
                legendItems.push({
                    item: {
                        color: fillColor,
                        childId: key,
                        label: label,
                        path: node[group_by_rollup_1.PATH_KEY],
                        depth: node[group_by_rollup_1.DEPTH_KEY] - 1,
                        seriesIdentifiers: [{ key: key, specId: specId }],
                        keys: [],
                        defaultExtra: {
                            raw: node[group_by_rollup_1.AGGREGATE_KEY],
                            formatted: valueFormatter(node[group_by_rollup_1.AGGREGATE_KEY]),
                            legendSizingLabel: "".concat(node[group_by_rollup_1.AGGREGATE_KEY]),
                        },
                    },
                    node: node,
                });
                uniqueNames.add(uniqueKey);
            }
            var children = node[group_by_rollup_1.CHILDREN_KEY];
            walkTree(specId, useHierarchicalLegend, valueFormatter, children, layers, depth + 1, uniqueNames, legendItems);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (tree_2_1 && !tree_2_1.done && (_a = tree_2.return)) _a.call(tree_2);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return legendItems;
}
//# sourceMappingURL=compute_legend.js.map