"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pickShapesTooltipValues = exports.pickShapesLayerValues = exports.pickedShapes = void 0;
var viewmodel_1 = require("./viewmodel");
var config_1 = require("../config");
var group_by_rollup_1 = require("../utils/group_by_rollup");
var pickedShapes = function (models, _a, foci) {
    var x = _a.x, y = _a.y;
    return models.flatMap(function (_a) {
        var diskCenter = _a.diskCenter, pickQuads = _a.pickQuads;
        return pickQuads(x - diskCenter.x, y - diskCenter.y, foci[0]);
    });
};
exports.pickedShapes = pickedShapes;
function pickShapesLayerValues(shapes) {
    var maxDepth = shapes.reduce(function (acc, curr) { return Math.max(acc, curr.depth); }, 0);
    return shapes
        .filter(function (_a) {
        var depth = _a.depth;
        return depth === maxDepth;
    })
        .map(function (viewModel) {
        var values = [
            {
                smAccessorValue: viewModel.smAccessorValue,
                groupByRollup: viewModel.dataName,
                value: viewModel[group_by_rollup_1.AGGREGATE_KEY],
                depth: viewModel[group_by_rollup_1.DEPTH_KEY],
                sortIndex: viewModel[group_by_rollup_1.SORT_INDEX_KEY],
                path: viewModel[group_by_rollup_1.PATH_KEY],
            },
        ];
        var node = viewModel[config_1.MODEL_KEY];
        while (node[group_by_rollup_1.DEPTH_KEY] > 0) {
            var value = node[group_by_rollup_1.AGGREGATE_KEY];
            var dataName = (0, group_by_rollup_1.getNodeName)(node);
            values.push({
                smAccessorValue: viewModel.smAccessorValue,
                groupByRollup: dataName,
                value: value,
                depth: node[group_by_rollup_1.DEPTH_KEY],
                sortIndex: node[group_by_rollup_1.SORT_INDEX_KEY],
                path: node[group_by_rollup_1.PATH_KEY],
            });
            node = node[group_by_rollup_1.PARENT_KEY];
        }
        return values.reverse();
    });
}
exports.pickShapesLayerValues = pickShapesLayerValues;
function pickShapesTooltipValues(shapes, shapeViewModel, valueGetter, valueFormatter, percentFormatter, id) {
    var maxDepth = shapes.reduce(function (acc, curr) { return Math.max(acc, curr.depth); }, 0);
    var currentShapeViewModel = shapeViewModel.find(function (d) { var _a; return d.smAccessorValue === ((_a = shapes[0]) === null || _a === void 0 ? void 0 : _a.smAccessorValue); });
    if (!currentShapeViewModel) {
        return { values: [], header: null };
    }
    var labelFormatters = currentShapeViewModel.layers.map(function (d) { return d.nodeLabel; });
    return {
        header: null,
        values: shapes
            .filter(function (_a) {
            var depth = _a.depth;
            return depth === maxDepth;
        })
            .flatMap(function (viewModel) {
            var values = [
                getTooltipValueFromNode((0, group_by_rollup_1.entryValue)(viewModel[group_by_rollup_1.PARENT_KEY][group_by_rollup_1.CHILDREN_KEY][viewModel[group_by_rollup_1.SORT_INDEX_KEY]]), labelFormatters, valueFormatter, percentFormatter, currentShapeViewModel, id),
            ];
            if ((0, viewmodel_1.isLinear)(currentShapeViewModel.layout)) {
                return values;
            }
            var node = viewModel[config_1.MODEL_KEY];
            while (node[group_by_rollup_1.DEPTH_KEY] > 0) {
                values.push(getTooltipValueFromNode(node, labelFormatters, valueFormatter, percentFormatter, currentShapeViewModel, id));
                node = node[group_by_rollup_1.PARENT_KEY];
            }
            return values.reverse();
        }),
    };
}
exports.pickShapesTooltipValues = pickShapesTooltipValues;
function getTooltipValueFromNode(node, labelFormatters, valueFormatter, percentFormatter, shapeViewModel, id) {
    var _a, _b;
    var depth = node[group_by_rollup_1.DEPTH_KEY];
    var value = node[group_by_rollup_1.AGGREGATE_KEY];
    var dataName = (0, group_by_rollup_1.getNodeName)(node);
    var formatter = labelFormatters[depth - 1];
    var model = shapeViewModel.quadViewModel.find(function (d) { return d.depth === depth && d.dataName === dataName && d.value === value; });
    return {
        label: formatter ? formatter(dataName) : dataName,
        color: (_a = model === null || model === void 0 ? void 0 : model.fillColor) !== null && _a !== void 0 ? _a : 'transparent',
        isHighlighted: false,
        isVisible: true,
        seriesIdentifier: {
            specId: id,
            key: (_b = model === null || model === void 0 ? void 0 : model.dataName) !== null && _b !== void 0 ? _b : '',
        },
        value: node[group_by_rollup_1.AGGREGATE_KEY],
        formattedValue: "".concat(valueFormatter(value), "\u00A0(").concat(percentFormatter((0, config_1.percentValueGetter)(node)), ")"),
        valueAccessor: node[group_by_rollup_1.DEPTH_KEY],
    };
}
//# sourceMappingURL=picked_shapes.js.map