"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricText = void 0;
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importDefault(require("react"));
var default_theme_attributes_1 = require("../../../../common/default_theme_attributes");
var canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
var common_1 = require("../../../../utils/common");
var wrap_1 = require("../../../../utils/text/wrap");
var specs_1 = require("../../specs");
var WIDTH_BP = [
    [0, 180, 's'],
    [180, 300, 'm'],
    [300, 600, 'l'],
    [600, 1000, 'xl'],
    [1000, 2000, 'xxl'],
    [2000, Infinity, 'xxxl'],
];
var PADDING = 8;
var LINE_HEIGHT = 1.2;
var ICON_SIZE = { s: 16, m: 16, l: 24, xl: 36, xxl: 44, xxxl: 64 };
var TITLE_FONT_SIZE = { s: 12, m: 16, l: 16, xl: 24, xxl: 32, xxxl: 42 };
var SUBTITLE_FONT_SIZE = { s: 10, m: 14, l: 14, xl: 20, xxl: 26, xxxl: 26 };
var EXTRA_FONT_SIZE = { s: 10, m: 14, l: 14, xl: 20, xxl: 26, xxxl: 26 };
var VALUE_FONT_SIZE = { s: 22, m: 27, l: 34, xl: 56, xxl: 88, xxxl: 140 };
var VALUE_PART_FONT_SIZE = { s: 16, m: 20, l: 24, xl: 40, xxl: 68, xxxl: 110 };
function findRange(ranges, value) {
    var range = ranges.find(function (_a) {
        var _b = __read(_a, 2), min = _b[0], max = _b[1];
        return min <= value && value < max;
    });
    return range ? range[2] : ranges[0][2];
}
function elementVisibility(datum, panel, size) {
    var LEFT_RIGHT_PADDING = 16;
    var maxTitlesWidth = (size === 's' ? 1 : 0.8) * panel.width - (datum.icon ? 24 : 0) - LEFT_RIGHT_PADDING;
    var titleFont = {
        fontStyle: 'normal',
        fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
        fontVariant: 'normal',
        fontWeight: 400,
        textColor: 'black',
    };
    var subtitleFont = __assign(__assign({}, titleFont), { fontWeight: 300 });
    var titleHeight = function (maxLines, textMeasure) {
        return datum.title
            ? PADDING +
                (0, wrap_1.wrapText)(datum.title, titleFont, TITLE_FONT_SIZE[size], maxTitlesWidth, maxLines, textMeasure).length *
                    TITLE_FONT_SIZE[size] *
                    LINE_HEIGHT
            : 0;
    };
    var subtitleHeight = function (maxLines, textMeasure) {
        return datum.subtitle
            ? PADDING +
                (0, wrap_1.wrapText)(datum.subtitle, subtitleFont, SUBTITLE_FONT_SIZE[size], maxTitlesWidth, maxLines, textMeasure)
                    .length *
                    SUBTITLE_FONT_SIZE[size] *
                    LINE_HEIGHT
            : 0;
    };
    var extraHeight = EXTRA_FONT_SIZE[size] * LINE_HEIGHT;
    var valueHeight = VALUE_FONT_SIZE[size] * LINE_HEIGHT + PADDING;
    var responsiveBreakPoints = [
        { titleMaxLines: 3, subtitleMaxLines: 2, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 3, subtitleMaxLines: 1, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 2, subtitleMaxLines: 1, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 1, subtitleMaxLines: 1, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 1, subtitleMaxLines: 0, title: !!datum.title, subtitle: false, extra: !!datum.extra },
        { titleMaxLines: 1, subtitleMaxLines: 0, title: !!datum.title, subtitle: false, extra: false },
        { titleMaxLines: 1, subtitleMaxLines: 0, title: !!datum.title, subtitle: false, extra: false },
    ];
    var isVisible = function (_a, measure) {
        var titleMaxLines = _a.titleMaxLines, subtitleMaxLines = _a.subtitleMaxLines, title = _a.title, subtitle = _a.subtitle, extra = _a.extra;
        return (title && titleMaxLines > 0 ? titleHeight(titleMaxLines, measure) : 0) +
            (subtitle && subtitleMaxLines > 0 ? subtitleHeight(subtitleMaxLines, measure) : 0) +
            (extra ? extraHeight : 0) +
            valueHeight <
            panel.height;
    };
    return (0, canvas_text_bbox_calculator_1.withTextMeasure)(function (textMeasure) {
        var _a, _b, _c;
        var visibilityBreakpoint = (_a = responsiveBreakPoints.find(function (breakpoint) { return isVisible(breakpoint, textMeasure); })) !== null && _a !== void 0 ? _a : responsiveBreakPoints[responsiveBreakPoints.length - 1];
        return __assign(__assign({}, visibilityBreakpoint), { titleLines: (0, wrap_1.wrapText)((_b = datum.title) !== null && _b !== void 0 ? _b : '', titleFont, TITLE_FONT_SIZE[size], maxTitlesWidth, visibilityBreakpoint.titleMaxLines, textMeasure), subtitleLines: (0, wrap_1.wrapText)((_c = datum.subtitle) !== null && _c !== void 0 ? _c : '', subtitleFont, SUBTITLE_FONT_SIZE[size], maxTitlesWidth, visibilityBreakpoint.subtitleMaxLines, textMeasure) });
    });
}
function lineClamp(maxLines) {
    return {
        textOverflow: 'ellipsis',
        display: '-webkit-box',
        WebkitLineClamp: maxLines,
        lineClamp: maxLines,
        WebkitBoxOrient: 'vertical',
        overflow: 'hidden',
    };
}
var MetricText = function (_a) {
    var id = _a.id, datum = _a.datum, panel = _a.panel, style = _a.style, onElementClick = _a.onElementClick, highContrastTextColor = _a.highContrastTextColor;
    var extra = datum.extra, value = datum.value;
    var size = findRange(WIDTH_BP, panel.width - 16);
    var hasProgressBar = (0, specs_1.isMetricWProgress)(datum);
    var progressBarDirection = (0, specs_1.isMetricWProgress)(datum) ? datum.progressBarDirection : undefined;
    var containerClassName = (0, classnames_1.default)('echMetricText', {
        'echMetricText--small': hasProgressBar,
        'echMetricText--vertical': progressBarDirection === common_1.LayoutDirection.Vertical,
        'echMetricText--horizontal': progressBarDirection === common_1.LayoutDirection.Horizontal,
    });
    var visibility = elementVisibility(datum, panel, size);
    var titleWidthMaxSize = size === 's' ? '100%' : '80%';
    var titlesWidth = "min(".concat(titleWidthMaxSize, ", calc(").concat(titleWidthMaxSize, " - ").concat(datum.icon ? '24px' : '0px', "))");
    var isNumericalMetric = (0, specs_1.isMetricWNumber)(datum);
    var textParts = isNumericalMetric
        ? (0, common_1.isFiniteNumber)(value)
            ? splitNumericSuffixPrefix(datum.valueFormatter(value))
            : [{ emphasis: 'normal', text: style.nonFiniteText }]
        : [{ emphasis: 'normal', text: datum.value }];
    return (react_1.default.createElement("div", { className: containerClassName, style: { color: highContrastTextColor } },
        react_1.default.createElement("div", null,
            visibility.title && (react_1.default.createElement("h2", { id: id, className: "echMetricText__title" },
                react_1.default.createElement("button", { onMouseDown: function (e) { return e.stopPropagation(); }, onMouseUp: function (e) { return e.stopPropagation(); }, onClick: function (e) {
                        e.stopPropagation();
                        onElementClick();
                    } },
                    react_1.default.createElement("span", { style: __assign({ fontSize: "".concat(TITLE_FONT_SIZE[size], "px"), whiteSpace: 'pre-wrap', width: titlesWidth }, lineClamp(visibility.titleLines.length)), title: datum.title }, datum.title)))),
            datum.icon && (react_1.default.createElement("div", { className: "echMetricText__icon" }, (0, common_1.renderWithProps)(datum.icon, {
                width: ICON_SIZE[size],
                height: ICON_SIZE[size],
                color: highContrastTextColor,
            })))),
        react_1.default.createElement("div", null, visibility.subtitle && (react_1.default.createElement("p", { className: "echMetricText__subtitle", style: __assign({ fontSize: "".concat(SUBTITLE_FONT_SIZE[size], "px"), width: titlesWidth, whiteSpace: 'pre-wrap' }, lineClamp(visibility.subtitleLines.length)), title: datum.subtitle }, datum.subtitle))),
        react_1.default.createElement("div", { className: "echMetricText__gap" }),
        react_1.default.createElement("div", null, visibility.extra && (react_1.default.createElement("p", { className: "echMetricText__extra", style: { fontSize: "".concat(EXTRA_FONT_SIZE[size], "px") } }, extra))),
        react_1.default.createElement("div", null,
            react_1.default.createElement("p", { className: "echMetricText__value", style: {
                    fontSize: "".concat(VALUE_FONT_SIZE[size], "px"),
                    textOverflow: isNumericalMetric ? undefined : 'ellipsis',
                }, title: textParts.map(function (_a) {
                    var text = _a.text;
                    return text;
                }).join('') }, textParts.map(function (_a, i) {
                var emphasis = _a.emphasis, text = _a.text;
                return emphasis === 'small' ? (react_1.default.createElement("span", { key: "".concat(text).concat(i), className: "echMetricText__part", style: { fontSize: "".concat(VALUE_PART_FONT_SIZE[size], "px") } }, text)) : (text);
            })))));
};
exports.MetricText = MetricText;
function splitNumericSuffixPrefix(text) {
    return text
        .split('')
        .reduce(function (acc, curr) {
        var emphasis = curr === '.' || curr === ',' || (0, common_1.isFiniteNumber)(Number.parseInt(curr)) ? 'normal' : 'small';
        if (acc.length > 0 && acc[acc.length - 1].emphasis === emphasis) {
            acc[acc.length - 1].textParts.push(curr);
        }
        else {
            acc.push({ emphasis: emphasis, textParts: [curr] });
        }
        return acc;
    }, [])
        .map(function (_a) {
        var emphasis = _a.emphasis, textParts = _a.textParts;
        return ({
            emphasis: emphasis,
            text: textParts.join(''),
        });
    });
}
//# sourceMappingURL=text.js.map