"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasPicketVisibleCells = exports.getPickedGridCell = exports.getPickedShapes = void 0;
var compute_chart_element_sizes_1 = require("./compute_chart_element_sizes");
var get_per_panel_heatmap_geometries_1 = require("./get_per_panel_heatmap_geometries");
var create_selector_1 = require("../../../../state/create_selector");
var get_active_pointer_position_1 = require("../../../../state/selectors/get_active_pointer_position");
exports.getPickedShapes = (0, create_selector_1.createCustomCachedSelector)([get_per_panel_heatmap_geometries_1.getPerPanelHeatmapGeometries, get_active_pointer_position_1.getActivePointerPosition], function (geoms, pointerPosition) {
    var picker = geoms.pickQuads;
    var x = pointerPosition.x, y = pointerPosition.y;
    return picker(x, y);
});
exports.getPickedGridCell = (0, create_selector_1.createCustomCachedSelector)([get_per_panel_heatmap_geometries_1.getPerPanelHeatmapGeometries, get_active_pointer_position_1.getActivePointerPosition, compute_chart_element_sizes_1.computeChartElementSizesSelector], function (geoms, pointerPosition) {
    return geoms.pickGridCell(pointerPosition.x, pointerPosition.y);
});
var hasPicketVisibleCells = function (pickedShapes) {
    return Array.isArray(pickedShapes) && pickedShapes.some(function (_a) {
        var visible = _a.visible;
        return visible;
    });
};
exports.hasPicketVisibleCells = hasPicketVisibleCells;
//# sourceMappingURL=picked_shapes.js.map