"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTooltipAnchorSelector = void 0;
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var picked_shapes_1 = require("./picked_shapes");
var create_selector_1 = require("../../../../state/create_selector");
var compute_small_multiple_scales_1 = require("../../../../state/selectors/compute_small_multiple_scales");
var get_active_pointer_position_1 = require("../../../../state/selectors/get_active_pointer_position");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
exports.getTooltipAnchorSelector = (0, create_selector_1.createCustomCachedSelector)([
    picked_shapes_1.getPickedShapes,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_active_pointer_position_1.getActivePointerPosition,
    compute_small_multiple_scales_1.computeSmallMultipleScalesSelector,
    get_chart_theme_1.getChartThemeSelector,
], function (shapes, _a, position, smScales, _b) {
    var chartDimensions = _a.chartDimensions;
    var heatmap = _b.heatmap;
    if (Array.isArray(shapes) && shapes.length > 0) {
        var _c = __read(shapes, 1), _d = _c[0], x = _d.x, y = _d.y, width = _d.width, height = _d.height, _e = _d.datum, _f = _e.smHorizontalAccessorValue, smHorizontalAccessorValue = _f === void 0 ? '' : _f, _g = _e.smVerticalAccessorValue, smVerticalAccessorValue = _g === void 0 ? '' : _g;
        var scaledPanelXOffset = smScales.horizontal.scale(smHorizontalAccessorValue);
        var scaledPanelYOffset = smScales.vertical.scale(smVerticalAccessorValue);
        var panelXOffset = isNaN(scaledPanelXOffset) ? 0 : scaledPanelXOffset;
        var panelYOffset = isNaN(scaledPanelYOffset) ? 0 : scaledPanelYOffset;
        return {
            x: x + chartDimensions.left + panelXOffset,
            width: width,
            y: y - chartDimensions.top + panelYOffset + heatmap.grid.stroke.width,
            height: height,
        };
    }
    return {
        x: position.x,
        width: 0,
        y: position.y,
        height: 0,
    };
});
//# sourceMappingURL=get_tooltip_anchor.js.map