"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPickedCells = void 0;
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_per_panel_heatmap_geometries_1 = require("./get_per_panel_heatmap_geometries");
var create_selector_1 = require("../../../../state/create_selector");
var get_last_drag_1 = require("../../../../state/selectors/get_last_drag");
exports.getPickedCells = (0, create_selector_1.createCustomCachedSelector)([get_per_panel_heatmap_geometries_1.getPerPanelHeatmapGeometries, get_last_drag_1.getLastDragSelector, compute_chart_dimensions_1.computeChartDimensionsSelector], function (geoms, dragState, _a) {
    var chartDimensions = _a.chartDimensions;
    if (!dragState) {
        return null;
    }
    if (dragState.start.position.x < chartDimensions.left && dragState.end.position.x < chartDimensions.left) {
        var fittedDragStateStart = { x: chartDimensions.left, y: dragState.start.position.y };
        var _b = geoms.pickDragArea([fittedDragStateStart, dragState.end.position]), y = _b.y, cells = _b.cells;
        return { x: [], y: y, cells: cells };
    }
    if (dragState.start.position.y > chartDimensions.height && dragState.end.position.y > chartDimensions.height) {
        var fittedDragStateStart = { x: dragState.start.position.x, y: chartDimensions.height };
        var _c = geoms.pickDragArea([fittedDragStateStart, dragState.end.position]), x = _c.x, cells = _c.cells;
        return { x: x, y: [], cells: cells };
    }
    return geoms.pickDragArea([dragState.start.position, dragState.end.position]);
});
//# sourceMappingURL=get_picked_cells.js.map