"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHighlightedAreaSelector = exports.getHighlightedDataSelector = void 0;
var get_heatmap_spec_1 = require("./get_heatmap_spec");
var get_per_panel_heatmap_geometries_1 = require("./get_per_panel_heatmap_geometries");
var is_brushing_1 = require("./is_brushing");
var create_selector_1 = require("../../../../state/create_selector");
exports.getHighlightedDataSelector = (0, create_selector_1.createCustomCachedSelector)([get_heatmap_spec_1.getHeatmapSpecSelector, is_brushing_1.isBrushingSelector], function (spec, isBrushing) {
    if (!spec.highlightedData || isBrushing) {
        return null;
    }
    return spec.highlightedData;
});
exports.getHighlightedAreaSelector = (0, create_selector_1.createCustomCachedSelector)([get_per_panel_heatmap_geometries_1.getPerPanelHeatmapGeometries, get_heatmap_spec_1.getHeatmapSpecSelector, is_brushing_1.isBrushingSelector], function (geoms, spec, isBrushing) {
    if (!spec.highlightedData || isBrushing) {
        return null;
    }
    var _a = spec.highlightedData, x = _a.x, y = _a.y, smHorizontalAccessorValue = _a.smHorizontalAccessorValue, smVerticalAccessorValue = _a.smVerticalAccessorValue;
    return geoms.pickHighlightedArea(x, y, smHorizontalAccessorValue, smVerticalAccessorValue);
});
//# sourceMappingURL=get_highlighted_area.js.map