"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHeatmapTableSelector = void 0;
var d3_array_1 = require("d3-array");
var get_heatmap_spec_1 = require("./get_heatmap_spec");
var predicate_1 = require("../../../../common/predicate");
var constants_1 = require("../../../../scales/constants");
var create_selector_1 = require("../../../../state/create_selector");
var get_settings_spec_1 = require("../../../../state/selectors/get_settings_spec");
var get_small_multiples_index_order_1 = require("../../../../state/selectors/get_small_multiples_index_order");
var accessor_1 = require("../../../../utils/accessor");
var elasticsearch_1 = require("../../../../utils/chrono/elasticsearch");
var common_1 = require("../../../../utils/common");
exports.getHeatmapTableSelector = (0, create_selector_1.createCustomCachedSelector)([get_heatmap_spec_1.getHeatmapSpecSelector, get_settings_spec_1.getSettingsSpecSelector, get_small_multiples_index_order_1.getSmallMultiplesIndexOrderSelector], function (spec, _a, smallMultiples) {
    var _b, _c, _d, _e, _f, _g;
    var xDomain = _a.xDomain;
    var data = spec.data, valueAccessor = spec.valueAccessor, xAccessor = spec.xAccessor, yAccessor = spec.yAccessor, xSortPredicate = spec.xSortPredicate, ySortPredicate = spec.ySortPredicate, xScale = spec.xScale, timeZone = spec.timeZone;
    var smVValues = new Set();
    var smHValues = new Set();
    var resultData = data.reduce(function (acc, curr, index) {
        var _a, _b, _c, _d;
        var x = (0, accessor_1.getAccessorValue)(curr, xAccessor);
        var y = (0, accessor_1.getAccessorValue)(curr, yAccessor);
        var value = (0, accessor_1.getAccessorValue)(curr, valueAccessor);
        if (!(0, common_1.isNonNullablePrimitiveValue)(x) || !(0, common_1.isNonNullablePrimitiveValue)(y)) {
            return acc;
        }
        if ((0, common_1.isFiniteNumber)(value)) {
            acc.extent = [Math.min(acc.extent[0], value), Math.max(acc.extent[1], value)];
            var smH = (_b = (_a = smallMultiples === null || smallMultiples === void 0 ? void 0 : smallMultiples.horizontal) === null || _a === void 0 ? void 0 : _a.by) === null || _b === void 0 ? void 0 : _b.call(_a, spec, curr);
            var smV = (_d = (_c = smallMultiples === null || smallMultiples === void 0 ? void 0 : smallMultiples.vertical) === null || _c === void 0 ? void 0 : _c.by) === null || _d === void 0 ? void 0 : _d.call(_c, spec, curr);
            if (!(0, common_1.isNil)(smH))
                smHValues.add(smH);
            if (!(0, common_1.isNil)(smV))
                smVValues.add(smV);
            acc.table.push({
                x: x,
                y: y,
                value: value,
                originalIndex: index,
                smVerticalAccessorValue: smV,
                smHorizontalAccessorValue: smH,
            });
        }
        if (!acc.xValues.includes(x)) {
            acc.xValues.push(x);
        }
        if (!acc.yValues.includes(y)) {
            acc.yValues.push(y);
        }
        return acc;
    }, {
        table: [],
        xValues: [],
        yValues: [],
        smHDomain: [],
        smVDomain: [],
        extent: [+Infinity, -Infinity],
        xNumericExtent: [+Infinity, -Infinity],
    });
    if (xScale.type === constants_1.ScaleType.Time) {
        var _h = __read((0, d3_array_1.extent)(resultData.xValues), 2), _j = _h[0], xDataMin = _j === void 0 ? NaN : _j, _k = _h[1], xDataMax = _k === void 0 ? NaN : _k;
        var dataMaxExtended = xDataMax ? (0, elasticsearch_1.addIntervalToTime)(xDataMax, xScale.interval, timeZone) : NaN;
        var _l = __read(!Array.isArray(xDomain) ? [(_b = xDomain === null || xDomain === void 0 ? void 0 : xDomain.min) !== null && _b !== void 0 ? _b : NaN, (_c = xDomain === null || xDomain === void 0 ? void 0 : xDomain.max) !== null && _c !== void 0 ? _c : NaN] : [NaN, NaN], 2), customMin = _l[0], customMax = _l[1];
        var _m = __read((0, d3_array_1.extent)([xDataMin, customMin, customMax, dataMaxExtended]), 2), min = _m[0], max = _m[1];
        resultData.xNumericExtent = [min !== null && min !== void 0 ? min : NaN, max !== null && max !== void 0 ? max : NaN];
        resultData.xValues =
            (0, common_1.isFiniteNumber)(min) && (0, common_1.isFiniteNumber)(max) ? (0, elasticsearch_1.timeRange)(min, max, xScale.interval, timeZone) : [];
    }
    else if (xScale.type === constants_1.ScaleType.Ordinal) {
        resultData.xValues.sort((0, predicate_1.getPredicateFn)(xSortPredicate));
    }
    resultData.yValues.sort((0, predicate_1.getPredicateFn)(ySortPredicate));
    var horizontalPredicate = (_e = (_d = smallMultiples === null || smallMultiples === void 0 ? void 0 : smallMultiples.horizontal) === null || _d === void 0 ? void 0 : _d.sort) !== null && _e !== void 0 ? _e : predicate_1.Predicate.DataIndex;
    var smHDomain = __spreadArray([], __read(smHValues), false).sort((0, predicate_1.getPredicateFn)(horizontalPredicate));
    var verticalPredicate = (_g = (_f = smallMultiples === null || smallMultiples === void 0 ? void 0 : smallMultiples.vertical) === null || _f === void 0 ? void 0 : _f.sort) !== null && _g !== void 0 ? _g : predicate_1.Predicate.DataIndex;
    var smVDomain = __spreadArray([], __read(smVValues), false).sort((0, predicate_1.getPredicateFn)(verticalPredicate));
    return __assign(__assign({}, resultData), { smHDomain: smHDomain, smVDomain: smVDomain });
});
//# sourceMappingURL=get_heatmap_table.js.map