"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDebugStateSelector = void 0;
var compute_chart_element_sizes_1 = require("./compute_chart_element_sizes");
var compute_legend_1 = require("./compute_legend");
var get_heatmap_spec_1 = require("./get_heatmap_spec");
var get_highlighted_area_1 = require("./get_highlighted_area");
var get_per_panel_heatmap_geometries_1 = require("./get_per_panel_heatmap_geometries");
var color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
var create_selector_1 = require("../../../../state/create_selector");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var common_1 = require("../../../../utils/common");
exports.getDebugStateSelector = (0, create_selector_1.createCustomCachedSelector)([
    get_per_panel_heatmap_geometries_1.getPerPanelHeatmapGeometries,
    compute_legend_1.computeLegendSelector,
    get_highlighted_area_1.getHighlightedAreaSelector,
    get_highlighted_area_1.getHighlightedDataSelector,
    get_chart_theme_1.getChartThemeSelector,
    compute_chart_element_sizes_1.computeChartElementSizesSelector,
    get_heatmap_spec_1.getHeatmapSpecSelector,
], function (geoms, legend, pickedArea, highlightedData, _a, _b, _c) {
    var _d, _e, _f, _g, _h, _j, _k;
    var heatmap = _a.heatmap;
    var xAxisTickCadence = _b.xAxisTickCadence;
    var xAxisTitle = _c.xAxisTitle, yAxisTitle = _c.yAxisTitle;
    var heatmapViewModel = geoms.heatmapViewModels[0];
    var xAxisValues = (_d = heatmapViewModel === null || heatmapViewModel === void 0 ? void 0 : heatmapViewModel.xValues.filter(function (_, i) { return i % xAxisTickCadence === 0; })) !== null && _d !== void 0 ? _d : [];
    return {
        legend: getLegendState(legend),
        axes: {
            x: [
                __assign({ id: 'x', position: common_1.Position.Left, labels: xAxisValues.map(function (_a) {
                        var text = _a.text;
                        return text;
                    }), values: xAxisValues.map(function (_a) {
                        var value = _a.value;
                        return value;
                    }), gridlines: ((_f = (_e = heatmapViewModel === null || heatmapViewModel === void 0 ? void 0 : heatmapViewModel.gridLines) === null || _e === void 0 ? void 0 : _e.x) !== null && _f !== void 0 ? _f : []).map(function (line) { return ({ x: line.x1, y: line.y2 }); }) }, (xAxisTitle ? { title: xAxisTitle } : {})),
            ],
            y: [
                __assign({ id: 'y', position: common_1.Position.Bottom, labels: ((_g = heatmapViewModel === null || heatmapViewModel === void 0 ? void 0 : heatmapViewModel.yValues) !== null && _g !== void 0 ? _g : []).map(function (_a) {
                        var text = _a.text;
                        return text;
                    }), values: ((_h = heatmapViewModel === null || heatmapViewModel === void 0 ? void 0 : heatmapViewModel.yValues) !== null && _h !== void 0 ? _h : []).map(function (_a) {
                        var value = _a.value;
                        return value;
                    }), gridlines: ((_k = (_j = heatmapViewModel === null || heatmapViewModel === void 0 ? void 0 : heatmapViewModel.gridLines) === null || _j === void 0 ? void 0 : _j.y) !== null && _k !== void 0 ? _k : []).map(function (line) { return ({ x: line.x2, y: line.y1 }); }) }, (yAxisTitle ? { title: yAxisTitle } : {})),
            ],
        },
        heatmap: {
            cells: geoms.heatmapViewModels.flatMap(function (vm) {
                return vm.cells.map(function (cell) { return ({
                    x: cell.x,
                    y: cell.y,
                    datum: cell.datum,
                    fill: (0, color_library_wrappers_1.RGBATupleToString)(cell.fill.color),
                    formatted: cell.formatted,
                    value: cell.value,
                    valueShown: heatmap.cell.label.visible && Number.isFinite(vm.cellFontSize(cell)),
                }); });
            }),
            selection: {
                area: pickedArea,
                data: highlightedData,
            },
        },
    };
});
function getLegendState(legendItems) {
    var items = legendItems
        .filter(function (_a) {
        var isSeriesHidden = _a.isSeriesHidden;
        return !isSeriesHidden;
    })
        .map(function (_a) {
        var name = _a.label, color = _a.color, _b = __read(_a.seriesIdentifiers, 1), key = _b[0].key;
        return ({
            key: key,
            name: name,
            color: color,
        });
    });
    return { items: items };
}
//# sourceMappingURL=get_debug_state.js.map