"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCursorBandPositionSelector = void 0;
var get_per_panel_heatmap_geometries_1 = require("./get_per_panel_heatmap_geometries");
var get_tooltip_anchor_1 = require("./get_tooltip_anchor");
var picked_shapes_1 = require("./picked_shapes");
var specs_1 = require("../../../../specs");
var create_selector_1 = require("../../../../state/create_selector");
var get_internal_is_brushing_1 = require("../../../../state/selectors/get_internal_is_brushing");
var common_1 = require("../../../../utils/common");
var getExternalPointerEventStateSelector = function (state) { return state.externalEvents.pointer; };
exports.getCursorBandPositionSelector = (0, create_selector_1.createCustomCachedSelector)([
    get_per_panel_heatmap_geometries_1.getPerPanelHeatmapGeometries,
    getExternalPointerEventStateSelector,
    picked_shapes_1.getPickedShapes,
    get_tooltip_anchor_1.getTooltipAnchorSelector,
    get_internal_is_brushing_1.getInternalIsBrushingSelector,
], function (geoms, externalPointerEvent, pickedShapes, tooltipShape, isBrushing) {
    if (isBrushing)
        return;
    if ((0, specs_1.isPointerOverEvent)(externalPointerEvent)) {
        var x = externalPointerEvent.x;
        if (!(0, common_1.isNil)(x)) {
            var band = geoms.pickCursorBand(x);
            if (band) {
                return __assign(__assign({}, band), { fromExternalEvent: true });
            }
        }
    }
    if ((0, picked_shapes_1.hasPicketVisibleCells)(pickedShapes)) {
        return __assign(__assign({}, tooltipShape), { fromExternalEvent: false });
    }
});
//# sourceMappingURL=get_cursor_band.js.map