"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeChartDimensionsSelector = void 0;
var compute_axes_sizes_1 = require("./compute_axes_sizes");
var create_selector_1 = require("../../../../state/create_selector");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var getParentDimension = function (state) { return state.parentDimensions; };
exports.computeChartDimensionsSelector = (0, create_selector_1.createCustomCachedSelector)([getParentDimension, compute_axes_sizes_1.computeAxesSizesSelector, get_chart_theme_1.getChartThemeSelector], function (parentDimensions, axesSizes, _a) {
    var heatmap = _a.heatmap, chartPaddings = _a.chartPaddings;
    var chartHeight = parentDimensions.height -
        axesSizes.xAxisTitleVerticalSize -
        axesSizes.xAxisPanelTitleVerticalSize -
        axesSizes.xAxis.height -
        axesSizes.legendHeight -
        heatmap.grid.stroke.width / 2;
    var chartWidth = axesSizes.chartWidth;
    return {
        leftMargin: NaN,
        chartDimensions: {
            top: parentDimensions.top + heatmap.grid.stroke.width / 2 + chartPaddings.top,
            left: parentDimensions.left + axesSizes.xAxis.left + chartPaddings.left,
            width: Math.max(0, chartWidth - chartPaddings.left - chartPaddings.right),
            height: Math.max(0, chartHeight - chartPaddings.top - chartPaddings.bottom),
        },
    };
});
//# sourceMappingURL=compute_chart_dimensions.js.map