"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeAxesSizesSelector = void 0;
var get_heatmap_spec_1 = require("./get_heatmap_spec");
var get_heatmap_table_1 = require("./get_heatmap_table");
var create_selector_1 = require("../../../../state/create_selector");
var compute_small_multiple_scales_1 = require("../../../../state/selectors/compute_small_multiple_scales");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_internal_sm_domains_1 = require("../../../../state/selectors/get_internal_sm_domains");
var get_legend_size_1 = require("../../../../state/selectors/get_legend_size");
var get_small_multiples_spec_1 = require("../../../../state/selectors/get_small_multiples_spec");
var canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
var legend_1 = require("../../../../utils/legend");
var viewmodel_1 = require("../../layout/viewmodel/viewmodel");
var axis_1 = require("../utils/axis");
var getParentDimension = function (state) { return state.parentDimensions; };
exports.computeAxesSizesSelector = (0, create_selector_1.createCustomCachedSelector)([
    getParentDimension,
    get_legend_size_1.getLegendSizeSelector,
    get_heatmap_table_1.getHeatmapTableSelector,
    get_chart_theme_1.getChartThemeSelector,
    get_heatmap_spec_1.getHeatmapSpecSelector,
    get_small_multiples_spec_1.getSmallMultiplesSpec,
    get_internal_sm_domains_1.getInternalSmallMultiplesDomains,
], function (container, legendSize, _a, _b, _c, smSpec, _d) {
    var _e;
    var yValues = _a.yValues, xValues = _a.xValues;
    var heatmap = _b.heatmap, _f = _b.axes, axisTitleStyle = _f.axisTitle, axisPanelTitleStyle = _f.axisPanelTitle;
    var xAxisTitle = _c.xAxisTitle, yAxisTitle = _c.yAxisTitle, xAxisLabelFormatter = _c.xAxisLabelFormatter, yAxisLabelFormatter = _c.yAxisLabelFormatter, xScale = _c.xScale;
    var smHDomain = _d.smHDomain;
    var panelWidth = (0, compute_small_multiple_scales_1.getScale)(smHDomain, container.width, (_e = smSpec === null || smSpec === void 0 ? void 0 : smSpec.style) === null || _e === void 0 ? void 0 : _e.horizontalPanelPadding).bandwidth;
    return (0, canvas_text_bbox_calculator_1.withTextMeasure)(function (textMeasure) {
        var _a;
        var isLegendHorizontal = (0, legend_1.isHorizontalLegend)(legendSize.position);
        var legendWidth = !isLegendHorizontal ? legendSize.width + legendSize.margin * 2 : 0;
        var legendHeight = isLegendHorizontal
            ? (_a = heatmap.maxLegendHeight) !== null && _a !== void 0 ? _a : legendSize.height + legendSize.margin * 2
            : 0;
        var yAxisTitleHorizontalSize = (0, axis_1.getTextSizeDimension)(yAxisTitle, axisTitleStyle, textMeasure, 'height');
        var yAxisPanelTitleHorizontalSize = (0, axis_1.getTextSizeDimension)(yAxisTitle, axisPanelTitleStyle, textMeasure, 'height', !(smSpec === null || smSpec === void 0 ? void 0 : smSpec.splitVertically));
        var yAxis = {
            width: (0, axis_1.getYAxisHorizontalUsedSpace)(yValues, heatmap.yAxisLabel, yAxisLabelFormatter, textMeasure),
        };
        var xAxisTitleVerticalSize = (0, axis_1.getTextSizeDimension)(xAxisTitle, axisTitleStyle, textMeasure, 'height');
        var xAxisPanelTitleVerticalSize = (0, axis_1.getTextSizeDimension)(xAxisTitle, axisPanelTitleStyle, textMeasure, 'height', !(smSpec === null || smSpec === void 0 ? void 0 : smSpec.splitHorizontally));
        var xAxis = (0, axis_1.getXAxisSize)(!(0, viewmodel_1.isRasterTimeScale)(xScale), heatmap.xAxisLabel, xAxisLabelFormatter, xValues, textMeasure, panelWidth - legendWidth - heatmap.grid.stroke.width / 2, [
            yAxisTitleHorizontalSize + yAxisPanelTitleHorizontalSize + yAxis.width,
            0,
        ]);
        var chartWidth = (0, axis_1.getXAxisSize)(!(0, viewmodel_1.isRasterTimeScale)(xScale), heatmap.xAxisLabel, xAxisLabelFormatter, xValues, textMeasure, container.width - legendWidth - heatmap.grid.stroke.width / 2, [
            yAxisTitleHorizontalSize + yAxisPanelTitleHorizontalSize + yAxis.width,
            0,
        ]).width;
        return {
            yAxis: yAxis,
            xAxis: xAxis,
            legendHeight: legendHeight,
            xAxisTitleVerticalSize: xAxisTitleVerticalSize,
            xAxisPanelTitleVerticalSize: xAxisPanelTitleVerticalSize,
            chartWidth: chartWidth,
        };
    });
});
//# sourceMappingURL=compute_axes_sizes.js.map