"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getColorBandStyle = exports.getGeometryStateStyle = void 0;
var color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
var viewmodel_1 = require("../../layout/viewmodel/viewmodel");
function getGeometryStateStyle(cell, sharedGeometryStyle, highlightedLegendBands) {
    var defaultStyles = sharedGeometryStyle.default, highlighted = sharedGeometryStyle.highlighted, unhighlighted = sharedGeometryStyle.unhighlighted;
    if (highlightedLegendBands.length > 0) {
        var isHighlightedBand = (0, viewmodel_1.isValueInRanges)(cell.value, highlightedLegendBands);
        return isHighlightedBand ? highlighted : unhighlighted;
    }
    return defaultStyles;
}
exports.getGeometryStateStyle = getGeometryStateStyle;
function getColorBandStyle(cell, geometryStateStyle) {
    var fillColor = (0, color_library_wrappers_1.overrideOpacity)(cell.fill.color, function (opacity) { return opacity * geometryStateStyle.opacity; });
    var fill = __assign(__assign({}, cell.fill), { color: fillColor });
    var strokeColor = (0, color_library_wrappers_1.overrideOpacity)(cell.stroke.color, function (opacity) { return opacity * geometryStateStyle.opacity; });
    var stroke = __assign(__assign({}, cell.stroke), { color: strokeColor });
    return { fill: fill, stroke: stroke };
}
exports.getColorBandStyle = getColorBandStyle;
//# sourceMappingURL=utils.js.map