"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderHeatmapCanvas2d = void 0;
var utils_1 = require("./utils");
var canvas_1 = require("../../../../renderers/canvas");
var common_1 = require("../../../../utils/common");
var dimensions_1 = require("../../../../utils/dimensions");
var line_1 = require("../../../xy_chart/renderer/canvas/primitives/line");
var rect_1 = require("../../../xy_chart/renderer/canvas/primitives/rect");
var text_1 = require("../../../xy_chart/renderer/canvas/primitives/text");
function renderHeatmapCanvas2d(ctx, dpr, props) {
    var theme = props.geometries.theme;
    var heatmapViewModels = props.geometries.heatmapViewModels;
    var sharedGeometryStyle = props.theme.sharedStyle, background = props.background, elementSizes = props.elementSizes, highlightedLegendBands = props.highlightedLegendBands;
    if (heatmapViewModels.length === 0)
        return;
    (0, canvas_1.withContext)(ctx, function () {
        ctx.scale(dpr, dpr);
        ctx.textAlign = 'center';
        ctx.textBaseline = 'middle';
        ctx.lineCap = 'square';
        (0, canvas_1.renderLayers)(ctx, [
            function () { return (0, canvas_1.clearCanvas)(ctx, background); },
            function () {
                heatmapViewModels.forEach(function (_a) {
                    var _b = _a.gridOrigin, x = _b.x, y = _b.y, gridLines = _a.gridLines;
                    (0, canvas_1.withContext)(ctx, function () {
                        ctx.translate(x, y);
                        (0, line_1.renderMultiLine)(ctx, gridLines.x, gridLines.stroke);
                        (0, line_1.renderMultiLine)(ctx, gridLines.y, gridLines.stroke);
                    });
                });
            },
            function () {
                return heatmapViewModels.forEach(function (_a) {
                    var _b = _a.gridOrigin, x = _b.x, y = _b.y, cells = _a.cells;
                    (0, canvas_1.withContext)(ctx, function () {
                        ctx.translate(x, y);
                        cells.forEach(function (cell) {
                            if (cell.visible) {
                                var geometryStateStyle = (0, utils_1.getGeometryStateStyle)(cell, sharedGeometryStyle, highlightedLegendBands);
                                var style = (0, utils_1.getColorBandStyle)(cell, geometryStateStyle);
                                (0, rect_1.renderRect)(ctx, cell, style.fill, style.stroke);
                            }
                        });
                    });
                });
            },
            function () {
                if (!theme.cell.label.visible)
                    return;
                heatmapViewModels.forEach(function (_a) {
                    var cellFontSize = _a.cellFontSize, _b = _a.gridOrigin, x = _b.x, y = _b.y, cells = _a.cells;
                    (0, canvas_1.withContext)(ctx, function () {
                        ctx.translate(x, y);
                        cells.forEach(function (cell) {
                            var fontSize = cellFontSize(cell);
                            if (cell.visible && Number.isFinite(fontSize))
                                (0, text_1.renderText)(ctx, { x: cell.x + cell.width / 2, y: cell.y + cell.height / 2 }, cell.formatted, __assign(__assign({}, theme.cell.label), { fontSize: fontSize, align: 'center', baseline: 'middle', textColor: cell.textColor }));
                        });
                    });
                });
            },
            function () {
                if (!theme.yAxisLabel.visible)
                    return;
                heatmapViewModels.forEach(function (_a) {
                    var yValues = _a.yValues, _b = _a.gridOrigin, x = _b.x, y = _b.y;
                    (0, canvas_1.withContext)(ctx, function () {
                        ctx.translate(x, y);
                        var font = __assign(__assign({}, theme.yAxisLabel), { baseline: 'middle', align: 'right' });
                        var padding = theme.yAxisLabel.padding;
                        var horizontalPadding = (0, dimensions_1.horizontalPad)(padding);
                        yValues.forEach(function (_a) {
                            var x = _a.x, y = _a.y, text = _a.text;
                            var textLines = (0, text_1.wrapLines)(ctx, text, font, theme.yAxisLabel.fontSize, Math.max(elementSizes.yAxis.width - horizontalPadding, 0), theme.yAxisLabel.fontSize, { shouldAddEllipsis: true, wrapAtWord: false }).lines;
                            (0, text_1.renderText)(ctx, { x: x, y: y }, textLines.length > 0 ? textLines[0] : '…', font);
                        });
                    });
                });
            },
            function () {
                if (!theme.xAxisLabel.visible)
                    return;
                heatmapViewModels.forEach(function (_a) {
                    var xValues = _a.xValues, _b = _a.gridOrigin, x = _b.x, y = _b.y;
                    (0, canvas_1.withContext)(ctx, function () {
                        ctx.translate(x, y + elementSizes.xAxis.top);
                        xValues
                            .filter(function (_, i) { return i % elementSizes.xAxisTickCadence === 0; })
                            .forEach(function (_a) {
                            var x = _a.x, y = _a.y, text = _a.text, align = _a.align;
                            var textLines = (0, text_1.wrapLines)(ctx, text, theme.xAxisLabel, theme.xAxisLabel.fontSize, Infinity, 16, { shouldAddEllipsis: true, wrapAtWord: false }).lines;
                            (0, text_1.renderText)(ctx, { x: x, y: y }, textLines.length > 0 ? textLines[0] : '…', __assign(__assign({}, theme.xAxisLabel), { baseline: 'middle', align: align }), (0, common_1.radToDeg)(-elementSizes.xLabelRotation));
                        });
                    });
                });
            },
            function () {
                return heatmapViewModels
                    .filter(function (_a) {
                    var titles = _a.titles;
                    return titles.length > 0;
                })
                    .forEach(function (_a) {
                    var titles = _a.titles, _b = _a.gridOrigin, x = _b.x, y = _b.y;
                    (0, canvas_1.withContext)(ctx, function () {
                        ctx.translate(x, y);
                        titles
                            .filter(function (t) { return t.visible && t.text !== ''; })
                            .forEach(function (title) {
                            (0, text_1.renderText)(ctx, title.origin, title.text, __assign(__assign({}, title), { baseline: 'middle', align: 'center' }), title.rotation);
                        });
                    });
                });
            },
        ]);
    });
}
exports.renderHeatmapCanvas2d = renderHeatmapCanvas2d;
//# sourceMappingURL=canvas_renderers.js.map