"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isRasterTimeScale = exports.isValueInRanges = exports.shapeViewModel = exports.clampWithOffset = void 0;
var d3_scale_1 = require("d3-scale");
var color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
var fill_text_color_1 = require("../../../../common/fill_text_color");
var panel_utils_1 = require("../../../../common/panel_utils");
var text_utils_1 = require("../../../../common/text_utils");
var constants_1 = require("../../../../scales/constants");
var elasticsearch_1 = require("../../../../utils/chrono/elasticsearch");
var common_1 = require("../../../../utils/common");
var dimensions_1 = require("../../../../utils/dimensions");
var logger_1 = require("../../../../utils/logger");
function getValuesInRange(values, startValue, endValue) {
    var startIndex = values.indexOf(startValue);
    var endIndex = Math.min(values.indexOf(endValue) + 1, values.length);
    return values.slice(startIndex, endIndex);
}
function clampWithOffset(value, lowerBound, upperBound, offset) {
    return (0, common_1.clamp)(value, lowerBound + offset, upperBound + offset) - offset;
}
exports.clampWithOffset = clampWithOffset;
function shapeViewModel(textMeasure, spec, _a, _b, elementSizes, heatmapTable, colorScale, smScales, groupBySpec, bandsToHide) {
    var _c, _d;
    var heatmapTheme = _a.heatmap, _e = _a.axes, axisTitle = _e.axisTitle, axisPanelTitle = _e.axisPanelTitle, background = _a.background;
    var chartDimensions = _b.chartDimensions;
    var table = heatmapTable.table, yValues = heatmapTable.yValues, xValues = heatmapTable.xValues;
    var gridStrokeWidth = heatmapTheme.grid.stroke.width;
    var isPointerOverPanel = (0, panel_utils_1.isPointerOverPanelFn)(smScales, chartDimensions, gridStrokeWidth);
    var boxedYValues = yValues.map(function (value) { return (__assign({ text: spec.yAxisLabelFormatter(value), value: value, isValue: false }, heatmapTheme.yAxisLabel)); });
    var panelSize = (0, panel_utils_1.getPanelSize)(smScales);
    var yScale = (0, d3_scale_1.scaleBand)().domain(yValues).range([0, panelSize.height]);
    var yInvertedScale = (0, d3_scale_1.scaleQuantize)().domain([0, panelSize.height]).range(yValues);
    var xScale = (0, d3_scale_1.scaleBand)().domain(xValues).range([0, panelSize.width]);
    var xInvertedScale = (0, d3_scale_1.scaleQuantize)().domain([0, panelSize.width]).range(xValues);
    var cellWidth = heatmapTheme.cell.maxWidth !== 'fill' && xScale.bandwidth() > heatmapTheme.cell.maxWidth
        ? heatmapTheme.cell.maxWidth
        : xScale.bandwidth();
    var cellHeight = yScale.bandwidth();
    var textXValues = getXTicks(spec, heatmapTheme.xAxisLabel, xScale, heatmapTable.xValues);
    var padding = heatmapTheme.yAxisLabel.padding;
    var textYValues = boxedYValues.map(function (d) {
        return __assign(__assign({}, d), { x: -(0, dimensions_1.pad)(padding, 'right'), y: cellHeight / 2 + (yScale(d.value) || 0), align: 'right' });
    });
    var cellWidthInner = cellWidth - gridStrokeWidth;
    var cellHeightInner = cellHeight - gridStrokeWidth;
    if ((0, color_library_wrappers_1.colorToRgba)(background.color)[3] < 1) {
        logger_1.Logger.expected('Text contrast requires a opaque background color, using fallbackColor', 'an opaque color', background.color);
    }
    var tableMinFontSize = Infinity;
    var panelCellMap = table.reduce(function (acc, d) {
        var _a;
        var x = xScale(String(d.x));
        var y = yScale(String(d.y));
        var yIndex = yValues.indexOf(d.y);
        if (!(0, common_1.isFiniteNumber)(x) || !(0, common_1.isFiniteNumber)(y) || yIndex === -1) {
            return acc;
        }
        var cellBackgroundColor = colorScale(d.value);
        var panelKey = getPanelKey(d.smHorizontalAccessorValue, d.smVerticalAccessorValue);
        var cellKey = getCellKey(d.x, d.y);
        var formattedValue = spec.valueFormatter(d.value);
        var fontSize = (0, text_utils_1.maximiseFontSize)(textMeasure, formattedValue, heatmapTheme.cell.label, heatmapTheme.cell.label.minFontSize, heatmapTheme.cell.label.maxFontSize, cellWidthInner - 6, cellHeightInner - 6);
        tableMinFontSize = Math.min(tableMinFontSize, fontSize);
        var cellMap = (_a = acc.get(panelKey)) !== null && _a !== void 0 ? _a : new Map();
        if (!acc.has(panelKey))
            acc.set(panelKey, cellMap);
        cellMap.set(cellKey, {
            x: (heatmapTheme.cell.maxWidth !== 'fill' ? x + xScale.bandwidth() / 2 - heatmapTheme.cell.maxWidth / 2 : x) +
                gridStrokeWidth / 2,
            y: y + gridStrokeWidth / 2,
            yIndex: yIndex,
            width: cellWidthInner,
            height: cellHeightInner,
            datum: d,
            fill: {
                color: (0, color_library_wrappers_1.colorToRgba)(cellBackgroundColor),
            },
            stroke: {
                color: (0, color_library_wrappers_1.colorToRgba)(heatmapTheme.cell.border.stroke),
                width: heatmapTheme.cell.border.strokeWidth,
            },
            value: d.value,
            visible: !isValueInRanges(d.value, bandsToHide),
            formatted: formattedValue,
            fontSize: fontSize,
            textColor: (0, fill_text_color_1.fillTextColor)(background.fallbackColor, cellBackgroundColor, background.color),
        });
        return acc;
    }, new Map());
    var getScaledSMValue = function (value, scale) {
        return (0, panel_utils_1.hasSMDomain)(smScales[scale]) ? smScales[scale].scale(value) : 0;
    };
    var getPanelPointCoordinate = function (value, scale) {
        var _a;
        var category = (_a = smScales[scale].invert(value)) !== null && _a !== void 0 ? _a : '';
        var panelOffset = getScaledSMValue(category, scale);
        var invertedScale = scale === 'horizontal' ? xInvertedScale : yInvertedScale;
        return {
            category: category,
            panelOffset: panelOffset,
            panelPixelValue: value - panelOffset,
            panelValue: invertedScale(value - panelOffset),
        };
    };
    var getPanelPointCoordinates = function (x, y) {
        var _a = getPanelPointCoordinate(y, 'vertical'), v = _a.category, panelY = _a.panelValue, panelOffsetY = _a.panelOffset;
        var _b = getPanelPointCoordinate(x, 'horizontal'), h = _b.category, panelX = _b.panelValue, panelOffsetX = _b.panelOffset;
        return {
            x: panelX,
            y: panelY,
            v: v,
            h: h,
            panelOffsetY: panelOffsetY,
            panelOffsetX: panelOffsetX,
        };
    };
    var pickGridCell = function (x, y) {
        if (x < chartDimensions.left || y < chartDimensions.top)
            return undefined;
        if (x > chartDimensions.width + chartDimensions.left || y > chartDimensions.top + chartDimensions.height)
            return undefined;
        var xValue = xInvertedScale(x - chartDimensions.left);
        var yValue = yInvertedScale(y);
        if (xValue === undefined || yValue === undefined)
            return undefined;
        return { x: xValue, y: yValue };
    };
    var pickQuads = function (x, y) {
        var _a;
        if (x > 0 &&
            x < chartDimensions.left &&
            y > chartDimensions.top &&
            y < chartDimensions.top + chartDimensions.height) {
            var yLabelKey_1 = yInvertedScale(y);
            var yLabelValue = textYValues.find(function (v) { return v.value === yLabelKey_1; });
            if (yLabelValue) {
                return yLabelValue;
            }
        }
        if (!isPointerOverPanel({ x: x, y: y })) {
            return [];
        }
        var _b = getPanelPointCoordinates(x - chartDimensions.left, y), xValue = _b.x, yValue = _b.y, h = _b.h, v = _b.v;
        if (xValue === undefined || yValue === undefined) {
            return [];
        }
        var panelKey = getPanelKey(h, v);
        var cellKey = getCellKey(xValue, yValue);
        var cell = (_a = panelCellMap.get(panelKey)) === null || _a === void 0 ? void 0 : _a.get(cellKey);
        if (cell)
            return [cell];
        return [];
    };
    var pickDragArea = function (bound) {
        var _a = __read(bound, 2), start = _a[0], end = _a[1];
        var left = chartDimensions.left, top = chartDimensions.top;
        var topLeft = [Math.min(start.x, end.x) - left, Math.min(start.y, end.y) - top];
        var bottomRight = [Math.max(start.x, end.x) - left, Math.max(start.y, end.y) - top];
        var _b = getPanelPointCoordinate(start.x, 'horizontal'), smHorizontalAccessorValue = _b.category, hOffset = _b.panelOffset;
        var _c = getPanelPointCoordinate(start.y, 'vertical'), smVerticalAccessorValue = _c.category, vOffset = _c.panelOffset;
        var panelStartX = clampWithOffset(topLeft[0], 0, panelSize.width, hOffset);
        var panelStartY = clampWithOffset(topLeft[1], 0, panelSize.height, vOffset);
        var panelEndX = clampWithOffset(bottomRight[0], 0, panelSize.width, hOffset);
        var panelEndY = clampWithOffset(bottomRight[1], 0, panelSize.height, vOffset);
        var startX = xInvertedScale(panelStartX);
        var startY = yInvertedScale(panelStartY);
        var endX = xInvertedScale(panelEndX);
        var endY = yInvertedScale(panelEndY);
        var allXValuesInRange = getValuesInRange(xValues, startX, endX);
        var allYValuesInRange = getValuesInRange(yValues, startY, endY);
        var invertedXValues = isRasterTimeScale(spec.xScale) && typeof endX === 'number'
            ? [startX, (0, elasticsearch_1.addIntervalToTime)(endX, spec.xScale.interval, spec.timeZone)]
            : __spreadArray([], __read(allXValuesInRange), false);
        var cells = [];
        allXValuesInRange.forEach(function (x) {
            allYValuesInRange.forEach(function (y) {
                var _a;
                var panelKey = getPanelKey(smHorizontalAccessorValue, smVerticalAccessorValue);
                var cellKey = getCellKey(x, y);
                var cellValue = (_a = panelCellMap.get(panelKey)) === null || _a === void 0 ? void 0 : _a.get(cellKey);
                if (cellValue)
                    cells.push(cellValue);
            });
        });
        return {
            cells: cells.filter(Boolean),
            x: invertedXValues,
            y: allYValuesInRange,
            smHorizontalAccessorValue: smHorizontalAccessorValue,
            smVerticalAccessorValue: smVerticalAccessorValue,
        };
    };
    var pickHighlightedArea = function (x, y, smHorizontalAccessorValue, smVerticalAccessorValue) {
        var startValue = x[0];
        var endValue = x[x.length - 1];
        var leftIndex = xValues.indexOf(startValue);
        var rightIndex = xValues.indexOf(endValue) + (isRasterTimeScale(spec.xScale) && x.length > 1 ? 0 : 1);
        var isRightOutOfRange = rightIndex > xValues.length - 1 || rightIndex < 0;
        var isLeftOutOfRange = leftIndex > xValues.length - 1 || leftIndex < 0;
        var startFromScale = xScale(isLeftOutOfRange ? xValues[0] : xValues[leftIndex]);
        var endFromScale = xScale(isRightOutOfRange ? xValues[xValues.length - 1] : xValues[rightIndex]);
        if (startFromScale === undefined || endFromScale === undefined) {
            return null;
        }
        var panelXOffset = (0, common_1.isNil)(smHorizontalAccessorValue)
            ? 0
            : getScaledSMValue(smHorizontalAccessorValue, 'horizontal');
        var panelYOffset = (0, common_1.isNil)(smVerticalAccessorValue) ? 0 : getScaledSMValue(smVerticalAccessorValue, 'vertical');
        var xStart = chartDimensions.left + startFromScale + panelXOffset;
        var width = endFromScale - startFromScale + (isRightOutOfRange || isLeftOutOfRange ? cellWidth : 0);
        var _a = y
            .filter(function (v) { return yValues.includes(v); })
            .reduce(function (acc, current, i) {
            if (i === 0) {
                acc.y = (yScale(current) || 0) + panelYOffset;
            }
            acc.totalHeight += cellHeight;
            return acc;
        }, { y: 0, totalHeight: 0 }), yStart = _a.y, totalHeight = _a.totalHeight;
        return {
            x: xStart,
            y: yStart,
            width: width,
            height: totalHeight,
        };
    };
    var pickDragShape = function (bound) {
        var _a = pickDragArea(bound), x = _a.x, y = _a.y, smHorizontalAccessorValue = _a.smHorizontalAccessorValue, smVerticalAccessorValue = _a.smVerticalAccessorValue;
        return pickHighlightedArea(x, y, smHorizontalAccessorValue, smVerticalAccessorValue);
    };
    var pickCursorBand = function (x) {
        var _a;
        var roundedValue = isRasterTimeScale(spec.xScale) && (0, common_1.isFiniteNumber)(x)
            ? (0, elasticsearch_1.roundDateToESInterval)(x, spec.xScale.interval, 'start', spec.timeZone)
            : x;
        var index = xValues.indexOf(roundedValue);
        return index < 0
            ? undefined
            : {
                width: cellWidth,
                x: chartDimensions.left + ((_a = xScale(xValues[index])) !== null && _a !== void 0 ? _a : NaN),
                y: chartDimensions.top,
                height: chartDimensions.height,
            };
    };
    var xLines = Array.from({ length: xValues.length + 1 }, function (d, i) {
        var xAxisExtension = i % elementSizes.xAxisTickCadence === 0 ? 5 : 0;
        return {
            x1: i * cellWidth,
            x2: i * cellWidth,
            y1: 0,
            y2: panelSize.height + xAxisExtension,
        };
    });
    var yLines = Array.from({ length: yValues.length + 1 }, function (d, i) { return ({
        x1: 0,
        x2: panelSize.width,
        y1: i * cellHeight,
        y2: i * cellHeight,
    }); });
    var axisTitleFont = {
        visible: axisTitle.visible,
        fontFamily: axisTitle.fontFamily,
        fontStyle: (_c = axisTitle.fontStyle) !== null && _c !== void 0 ? _c : 'normal',
        fontVariant: 'normal',
        fontWeight: 'bold',
        textColor: axisTitle.fill,
        fontSize: axisTitle.fontSize,
    };
    var axisPanelTitleFont = {
        visible: axisPanelTitle.visible,
        fontFamily: axisPanelTitle.fontFamily,
        fontStyle: (_d = axisPanelTitle.fontStyle) !== null && _d !== void 0 ? _d : 'normal',
        fontVariant: 'normal',
        fontWeight: 'bold',
        textColor: axisPanelTitle.fill,
        fontSize: axisPanelTitle.fontSize,
    };
    return {
        theme: heatmapTheme,
        heatmapViewModels: (0, panel_utils_1.getPerPanelMap)(smScales, function (anchor, h, v) {
            var _a, _b;
            var primaryColumn = smScales.vertical.domain[0] === v;
            var primaryRow = smScales.horizontal.domain[0] === h;
            var lastColumn = smScales.vertical.domain[smScales.vertical.domain.length - 1] === v;
            var titles = [];
            var cells = __spreadArray([], __read(((_b = (_a = panelCellMap.get(getPanelKey(h, v))) === null || _a === void 0 ? void 0 : _a.values()) !== null && _b !== void 0 ? _b : [])), false);
            if (primaryColumn && primaryRow) {
                if (spec.xAxisTitle) {
                    var axisPanelTitleHeight = groupBySpec.horizontal && axisPanelTitle.visible
                        ? axisPanelTitle.fontSize + (0, dimensions_1.innerPad)(axisPanelTitle.padding) / 2
                        : 0;
                    titles.push(__assign(__assign({ origin: {
                            x: chartDimensions.width / 2,
                            y: chartDimensions.top +
                                chartDimensions.height +
                                elementSizes.xAxis.height +
                                axisPanelTitleHeight +
                                (0, dimensions_1.innerPad)(axisTitle.padding) / 2 +
                                axisTitle.fontSize / 2,
                        } }, axisTitleFont), { text: spec.xAxisTitle, rotation: 0 }));
                }
                if (spec.yAxisTitle) {
                    titles.push(__assign(__assign({ origin: {
                            x: -chartDimensions.left + axisTitle.fontSize / 2,
                            y: chartDimensions.top + chartDimensions.height / 2,
                        } }, axisTitleFont), { text: spec.yAxisTitle, rotation: -90 }));
                }
            }
            if (primaryColumn && groupBySpec.horizontal) {
                titles.push(__assign(__assign({ origin: {
                        x: panelSize.width / 2,
                        y: chartDimensions.top +
                            chartDimensions.height +
                            elementSizes.xAxis.height +
                            (0, dimensions_1.innerPad)(axisPanelTitle.padding) +
                            axisPanelTitle.fontSize / 2,
                    } }, axisPanelTitleFont), { text: (0, panel_utils_1.getPanelTitle)(false, v, h, groupBySpec), rotation: 0 }));
            }
            if (primaryRow && groupBySpec.vertical) {
                var axisTitleWidth = axisTitle.visible ? axisTitle.fontSize + (0, dimensions_1.innerPad)(axisTitle.padding) : 0;
                titles.push(__assign(__assign({ origin: {
                        x: -chartDimensions.left + axisTitleWidth + axisPanelTitle.fontSize / 2,
                        y: chartDimensions.top + panelSize.height / 2,
                    } }, axisPanelTitleFont), { text: (0, panel_utils_1.getPanelTitle)(true, v, h, groupBySpec), rotation: -90 }));
            }
            return {
                anchor: anchor,
                panelSize: panelSize,
                gridOrigin: {
                    x: anchor.x + chartDimensions.left,
                    y: anchor.y + chartDimensions.top,
                },
                gridLines: {
                    x: xLines,
                    y: yLines,
                    stroke: {
                        color: (0, color_library_wrappers_1.colorToRgba)(heatmapTheme.grid.stroke.color),
                        width: gridStrokeWidth,
                    },
                },
                cells: cells,
                cellFontSize: function (cell) { return (heatmapTheme.cell.label.useGlobalMinFontSize ? tableMinFontSize : cell.fontSize); },
                xValues: lastColumn ? textXValues : [],
                yValues: primaryRow ? textYValues : [],
                titles: titles,
            };
        }),
        pickGridCell: pickGridCell,
        pickQuads: pickQuads,
        pickDragArea: pickDragArea,
        pickDragShape: pickDragShape,
        pickHighlightedArea: pickHighlightedArea,
        pickCursorBand: pickCursorBand,
    };
}
exports.shapeViewModel = shapeViewModel;
function getCellKey(x, y) {
    return [String(x), String(y)].join('&_&');
}
function getPanelKey(h, v) {
    if (h === void 0) { h = ''; }
    if (v === void 0) { v = ''; }
    return [String(h), String(v)].join('&_&');
}
function isValueInRanges(value, ranges) {
    return ranges.some(function (_a) {
        var _b = __read(_a, 2), min = _b[0], max = _b[1];
        return min <= value && value < max;
    });
}
exports.isValueInRanges = isValueInRanges;
function isRasterTimeScale(scale) {
    return scale.type === constants_1.ScaleType.Time;
}
exports.isRasterTimeScale = isRasterTimeScale;
function getXTicks(spec, style, scale, values) {
    var isTimeScale = isRasterTimeScale(spec.xScale);
    var isRotated = style.rotation !== 0;
    return values.map(function (value) {
        var _a;
        return __assign(__assign({ text: spec.xAxisLabelFormatter(value), value: value, isValue: false }, style), { y: style.fontSize / 2 + (0, dimensions_1.pad)(style.padding, 'top'), x: ((_a = scale(value)) !== null && _a !== void 0 ? _a : 0) + (isTimeScale ? 0 : scale.bandwidth() / 2), align: isRotated ? 'right' : isTimeScale ? 'left' : 'center' });
    });
}
//# sourceMappingURL=viewmodel.js.map