"use strict";

var _synthetics = require("@elastic/synthetics");

var _date_picker = require("../page_objects/date_picker");

var _utils = require("./utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const osNameMetric = 'ux-visitor-breakdown-user_agent-os-name';
const uaNameMetric = 'ux-visitor-breakdown-user_agent-name';
const chartIds = [osNameMetric, uaNameMetric];
(0, _synthetics.journey)('UX Visitor Breakdown', async ({
  page,
  params
}) => {
  (0, _synthetics.before)(async () => {
    await (0, _utils.waitForLoadingToFinish)({
      page
    });
  });
  const queryParams = {
    percentile: '50',
    rangeFrom: '2020-05-18T11:51:00.000Z',
    rangeTo: '2021-10-30T06:37:15.536Z'
  };
  const queryString = new URLSearchParams(queryParams).toString();
  const baseUrl = `${params.kibanaUrl}/app/ux`;
  (0, _synthetics.step)('Go to UX Dashboard', async () => {
    await page.goto(`${baseUrl}?${queryString}`, {
      waitUntil: 'networkidle'
    });
    await (0, _utils.loginToKibana)({
      page,
      user: {
        username: 'elastic',
        password: 'changeme'
      }
    });
  });
  (0, _synthetics.step)('Set date range', async () => {
    const datePickerPage = new _date_picker.UXDashboardDatePicker(page);
    await datePickerPage.setDefaultE2eRange();
  });
  (0, _synthetics.step)('Confirm charts are visible', async () => {
    // Wait until chart data is loaded
    await page.waitForLoadState('networkidle');
    await Promise.all(chartIds.map(async dataTestId => // lens embeddable injects its own test attribute
    await page.waitForSelector((0, _utils.byLensTestId)(dataTestId))));
  });
});