"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateMockUrlIndicator = exports.generateMockIndicator = exports.generateMockFileIndicator = exports.RawIndicatorFieldId = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RawIndicatorFieldId;
exports.RawIndicatorFieldId = RawIndicatorFieldId;

(function (RawIndicatorFieldId) {
  RawIndicatorFieldId["Type"] = "threat.indicator.type";
  RawIndicatorFieldId["FirstSeen"] = "threat.indicator.first_seen";
  RawIndicatorFieldId["LastSeen"] = "threat.indicator.last_seen";
  RawIndicatorFieldId["MarkingTLP"] = "threat.indicator.marking.tlp";
  RawIndicatorFieldId["Feed"] = "threat.feed.name";
  RawIndicatorFieldId["Ip"] = "threat.indicator.ip";
  RawIndicatorFieldId["EmailAddress"] = "threat.indicator.email.address";
  RawIndicatorFieldId["UrlFull"] = "threat.indicator.url.full";
  RawIndicatorFieldId["UrlOriginal"] = "threat.indicator.url.original";
  RawIndicatorFieldId["UrlDomain"] = "threat.indicator.url.domain";
  RawIndicatorFieldId["FileMd5"] = "threat.indicator.file.hash.md5";
  RawIndicatorFieldId["FileSha256"] = "threat.indicator.file.hash.sha256";
})(RawIndicatorFieldId || (exports.RawIndicatorFieldId = RawIndicatorFieldId = {}));

const generateMockIndicator = () => ({
  fields: {
    'threat.indicator.type': ['ipv4-addr'],
    'threat.indicator.ip': ['12.68.554.87'],
    'threat.indicator.first_seen': ['2022-01-01T01:01:01.000Z'],
    'threat.feed.name': ['Abuse_CH']
  },
  _id: Math.random()
});

exports.generateMockIndicator = generateMockIndicator;

const generateMockUrlIndicator = () => {
  const indicator = generateMockIndicator();
  indicator.fields['threat.indicator.type'] = ['url'];
  indicator.fields['threat.indicator.url.full'] = ['https://google.com'];
  return indicator;
};

exports.generateMockUrlIndicator = generateMockUrlIndicator;

const generateMockFileIndicator = () => {
  const indicator = generateMockIndicator();
  indicator.fields['threat.indicator.type'] = ['file'];
  indicator.fields['threat.indicator.file.hash.sha256'] = ['sample_sha256_hash'];
  return indicator;
};

exports.generateMockFileIndicator = generateMockFileIndicator;