"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllLocations = getAllLocations;

var _get_private_locations = require("./get_private_locations");

var _get_service_locations = require("./get_service_locations");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function getAllLocations(server, syntheticsMonitorClient, savedObjectsClient) {
  try {
    const [privateLocations, {
      locations: publicLocations,
      throttling
    }] = await Promise.all([(0, _get_private_locations.getPrivateLocations)(syntheticsMonitorClient, savedObjectsClient), (0, _get_service_locations.getServiceLocations)(server)]);
    return {
      publicLocations,
      privateLocations,
      throttling
    };
  } catch (e) {
    server.logger.error(e);
    return {
      publicLocations: [],
      privateLocations: []
    };
  }
}