"use strict";

var _synthetics = require("@elastic/synthetics");

var _utils = require("../../../../observability/e2e/utils");

var _monitor_management = require("../../page_objects/monitor_management");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
(0, _synthetics.journey)('AddPrivateLocationMonitor', async ({
  page,
  params: {
    kibanaUrl
  }
}) => {
  const uptime = (0, _monitor_management.monitorManagementPageProvider)({
    page,
    kibanaUrl
  });
  (0, _synthetics.before)(async () => {
    await uptime.waitForLoadingToFinish();
  });
  (0, _synthetics.step)('Go to monitor-management', async () => {
    await uptime.navigateToMonitorManagement();
  });
  (0, _synthetics.step)('login to Kibana', async () => {
    await uptime.loginToKibana();
    const invalid = await page.locator(`text=Username or password is incorrect. Please try again.`);
    (0, _synthetics.expect)(await invalid.isVisible()).toBeFalsy();
  });
  (0, _synthetics.step)('enable management', async () => {
    await uptime.enableMonitorManagement();
  });
  (0, _synthetics.step)('Click text=Add monitor', async () => {
    await page.click('text=Add monitor');
    (0, _synthetics.expect)(page.url()).toBe(`${kibanaUrl}/app/uptime/add-monitor`);
    await uptime.waitForLoadingToFinish();
    await page.click('input[name="name"]');
    await page.fill('input[name="name"]', 'Private location monitor');
    await page.click('label:has-text("Test private location Private")', _utils.TIMEOUT_60_SEC);
    await page.selectOption('select', 'http');
    await page.click((0, _utils.byTestId)('syntheticsUrlField'));
    await page.fill((0, _utils.byTestId)('syntheticsUrlField'), 'https://www.google.com');
    await page.click('text=Save monitor');
    await page.click('text=Private location monitor');
    await page.click('text=Private location monitorLast 15 minutes1 mRefresh >> span');
  });
  (0, _synthetics.step)('Click [placeholder="Find apps, content, and more. Ex: Discover"]', async () => {
    await page.click('[placeholder="Find apps, content, and more. Ex: Discover"]');
    await page.fill('[placeholder="Find apps, content, and more. Ex: Discover"]', 'integ');
    await Promise.all([page.waitForNavigation(), page.click('text=Integrations')]);
    await page.click('text=Installed integrations');
    (0, _synthetics.expect)(page.url()).toBe(`${kibanaUrl}/app/integrations/installed`);
    await page.click(`text=Elastic Synthetics`);
    await page.click('text=Integration policies');
  });
  (0, _synthetics.step)('Click text=Edit Elastic Synthetics integration', async () => {
    await (0, _utils.assertText)({
      page,
      text: 'This table contains 1 rows out of 1 rows; Page 1 of 1.'
    });
    await page.click('[data-test-subj="integrationNameLink"]');
    await page.click('text=Edit in uptime');
    await page.click('text=Private location monitor');
  });
});