"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryExecutor = void 0;

var _get_filter = require("../get_filter");

var _search_after_bulk_create = require("../search_after_bulk_create");

var _reason_formatters = require("../reason_formatters");

var _with_security_span = require("../../../../utils/with_security_span");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const queryExecutor = async ({
  inputIndex,
  runtimeMappings,
  completeRule,
  tuple,
  exceptionItems,
  listClient,
  experimentalFeatures,
  ruleExecutionLogger,
  eventsTelemetry,
  services,
  version,
  searchAfterSize,
  bulkCreate,
  wrapHits,
  primaryTimestamp,
  secondaryTimestamp
}) => {
  const ruleParams = completeRule.ruleParams;
  return (0, _with_security_span.withSecuritySpan)('queryExecutor', async () => {
    const esFilter = await (0, _get_filter.getFilter)({
      type: ruleParams.type,
      filters: ruleParams.filters,
      language: ruleParams.language,
      query: ruleParams.query,
      savedId: ruleParams.savedId,
      services,
      index: inputIndex,
      lists: exceptionItems
    });
    return (0, _search_after_bulk_create.searchAfterAndBulkCreate)({
      tuple,
      completeRule,
      services,
      listClient,
      exceptionsList: exceptionItems,
      ruleExecutionLogger,
      eventsTelemetry,
      inputIndexPattern: inputIndex,
      pageSize: searchAfterSize,
      filter: esFilter,
      buildReasonMessage: _reason_formatters.buildReasonMessageForQueryAlert,
      bulkCreate,
      wrapHits,
      runtimeMappings,
      primaryTimestamp,
      secondaryTimestamp
    });
  });
};

exports.queryExecutor = queryExecutor;