"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actionListHandler = void 0;

var _services = require("../../services");

var _error_handler = require("../error_handler");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const formatStringIds = value => typeof value === 'string' ? [value] : value;

const actionListHandler = endpointContext => {
  const logger = endpointContext.logFactory.get('endpoint_action_list');
  return async (context, req, res) => {
    const {
      query: {
        agentIds: elasticAgentIds,
        page,
        pageSize,
        startDate,
        endDate,
        userIds,
        commands
      }
    } = req;
    const esClient = (await context.core).elasticsearch.client.asInternalUser;

    try {
      const body = await (0, _services.getActionList)({
        commands: formatStringIds(commands),
        esClient,
        elasticAgentIds: formatStringIds(elasticAgentIds),
        page,
        pageSize,
        startDate,
        endDate,
        userIds: formatStringIds(userIds),
        logger
      });
      return res.ok({
        body
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, res, error);
    }
  };
};

exports.actionListHandler = actionListHandler;