"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuntimeServices = exports.createKbnClient = exports.createEsClient = void 0;

var _elasticsearch = require("@elastic/elasticsearch");

var _toolingLog = require("@kbn/tooling-log");

var _test = require("@kbn/test");

var _security_user_services = require("./security_user_services");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createRuntimeServices = async ({
  kibanaUrl,
  elasticsearchUrl,
  username: _username,
  password: _password,
  log = new _toolingLog.ToolingLog(),
  asSuperuser = false
}) => {
  let username = _username;
  let password = _password;

  if (asSuperuser) {
    const superuserResponse = await (0, _security_user_services.createSecuritySuperuser)(createEsClient({
      url: elasticsearchUrl,
      username,
      password,
      log
    }));
    ({
      username,
      password
    } = superuserResponse);

    if (superuserResponse.created) {
      log.info(`Kibana user [${username}] was crated with password [${password}]`);
    }
  }

  return {
    kbnClient: createKbnClient({
      log,
      url: kibanaUrl,
      username,
      password
    }),
    esClient: createEsClient({
      log,
      url: elasticsearchUrl,
      username,
      password
    }),
    log,
    user: {
      username,
      password
    }
  };
};

exports.createRuntimeServices = createRuntimeServices;

const buildUrlWithCredentials = (url, username, password) => {
  const newUrl = new URL(url);
  newUrl.username = username;
  newUrl.password = password;
  return newUrl.href;
};

const createEsClient = ({
  url,
  username,
  password,
  log
}) => {
  const esUrl = buildUrlWithCredentials(url, username, password);

  if (log) {
    log.verbose(`Creating Elasticsearch client with URL: ${esUrl}`);
  }

  return new _elasticsearch.Client({
    node: esUrl
  });
};

exports.createEsClient = createEsClient;

const createKbnClient = ({
  url,
  username,
  password,
  log = new _toolingLog.ToolingLog()
}) => {
  const kbnUrl = buildUrlWithCredentials(url, username, password);

  if (log) {
    log.verbose(`Creating Kibana client with URL: ${kbnUrl}`);
  }

  return new _test.KbnClient({
    log,
    url: kbnUrl
  });
};

exports.createKbnClient = createKbnClient;