"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSecuritySuperuser = void 0;

var _os = require("os");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createSecuritySuperuser = async (esClient, username = (0, _os.userInfo)().username, password = 'changeme') => {
  if (!username || !password) {
    throw new Error(`username and password require values.`);
  }

  const addedUser = await esClient.transport.request({
    method: 'POST',
    path: `_security/user/${username}`,
    body: {
      password,
      roles: ['superuser', 'kibana_system'],
      full_name: username
    }
  });
  return {
    created: addedUser.created,
    username,
    password
  };
};

exports.createSecuritySuperuser = createSecuritySuperuser;