"use strict";

var _synthetics = require("@elastic/synthetics");

var _exploratory_view_url = require("../../public/components/shared/exploratory_view/configurations/exploratory_view_url");

var _utils = require("../utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
(0, _synthetics.journey)('Exploratory view', async ({
  page,
  params
}) => {
  (0, _synthetics.before)(async () => {
    await (0, _utils.waitForLoadingToFinish)({
      page
    });
  });
  const expUrl = (0, _exploratory_view_url.createExploratoryViewUrl)({
    reportType: 'kpi-over-time',
    allSeries: [{
      name: 'Elastic page views',
      time: {
        from: '2021-01-18T12:20:01.682Z',
        to: '2021-01-18T12:25:27.484Z'
      },
      selectedMetricField: '___records___',
      reportDefinitions: {
        'service.name': []
      },
      dataType: 'ux'
    }]
  });
  const baseUrl = `${params.kibanaUrl}${expUrl}`;
  (0, _synthetics.step)('Go to Exploratory view', async () => {
    await page.goto(baseUrl, {
      waitUntil: 'networkidle'
    });
    await (0, _utils.loginToKibana)({
      page,
      user: {
        username: 'elastic',
        password: 'changeme'
      },
      dismissTour: false
    });
  });
  (0, _synthetics.step)('renders as expected', async () => {
    await Promise.all([page.waitForNavigation(_utils.TIMEOUT_60_SEC), page.click('text=Explore data')]);
    await page.click('text=User experience (RUM)');
    await page.click('[aria-label="Toggle series information"] >> text=Page views', _utils.TIMEOUT_60_SEC);
    await page.click('[aria-label="Edit series"]', _utils.TIMEOUT_60_SEC);
    await page.click('button:has-text("No breakdown")');
    await page.click('button[role="option"]:has-text("Operating system")');
    await page.click('button:has-text("Apply changes")');
    await page.click('text=Chrome OS');
    await page.click('text=iOS');
    await page.click('text=iOS');
    await page.click('text=Chrome OS');
    await page.click('text=Ubuntu');
    await page.click('text=Android');
    await page.click('text=Linux');
    await page.click('text=Mac OS X');
    await page.click('text=Windows');
    await page.click('h1:has-text("Explore data")');
  });
  (0, _synthetics.step)('Edit and change the series to distribution', async () => {
    await page.click('[aria-label="View series actions"]');
    await page.click('[aria-label="Remove series"]');
    await page.click('button:has-text("KPI over time")');
    await page.click('button[role="option"]:has-text("Performance distribution")');
    await page.click('button:has-text("Add series")');
    await page.click('button:has-text("Select data type")');
    await page.click('button:has-text("User experience (RUM)")');
    await page.click('button:has-text("Select report metric")');
    await page.click('button:has-text("Page load time")');
    await page.click('.euiComboBox__inputWrap');
    await page.click('[aria-label="Date quick select"]');
    await page.click('text=Last 1 year');
    await page.click('[aria-label="Date quick select"]');
    await page.click('[aria-label="Time value"]');
    await page.fill('[aria-label="Time value"]', '010');
    await page.selectOption('[aria-label="Time unit"]', 'y');
    await page.click('div[role="dialog"] button:has-text("Apply")');
    await page.click('.euiComboBox__inputWrap');
    await page.click('button[role="option"]:has-text("elastic-co-frontend")');
    await page.click('button:has-text("Apply changes")');
    await page.click('text=ux-series-1');
    await page.click('text=User experience (RUM)');
    await page.click('text=Page load time');
    await page.click('text=Pages loaded');
    await page.click('button:has-text("95th")');
    await page.click('button:has-text("90th")');
    await page.click('button:has-text("99th")');
    await page.click('[aria-label="Edit series"]');
    await page.click('button:has-text("No breakdown")');
    await page.click('button[role="option"]:has-text("Browser family")');
    await page.click('button:has-text("Apply changes")');
    await page.click('text=Edge');
    await page.click('text=Opera');
    await page.click('text=Safari');
    await page.click('text=HeadlessChrome');
    await page.click('[aria-label="Firefox; Activate to hide series in graph"]');
  });
});