"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineGetCspSetupStatusRoute = exports.INDEX_TIMEOUT_IN_MINUTES = void 0;

var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");

var _moment = _interopRequireDefault(require("moment"));

var _constants = require("../../../common/constants");

var _fleet_util = require("../../lib/fleet_util");

var _is_latest_findings_index_exists = require("../../lib/is_latest_findings_index_exists");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INDEX_TIMEOUT_IN_MINUTES = 10; // this function currently returns all agents instead of healthy agents only

exports.INDEX_TIMEOUT_IN_MINUTES = INDEX_TIMEOUT_IN_MINUTES;

const getHealthyAgents = async (soClient, installedIntegrations, agentPolicyService, agentService) => {
  const agentPolicies = await (0, _fleet_util.getCspAgentPolicies)(soClient, installedIntegrations, agentPolicyService);
  const enrichedAgentPolicies = await (0, _fleet_util.addRunningAgentToAgentPolicy)(agentService, agentPolicies || []);
  return enrichedAgentPolicies.reduce((previousValue, currentValue) => previousValue + (currentValue.agents || 0), 0);
};

const getMinutesPassedSinceMoment = momentInput => (0, _moment.default)().diff((0, _moment.default)(momentInput), 'minutes');

const getStatus = (findingsIndexExists, installedIntegrations, healthyAgents, minutesPassedSinceInstallation) => {
  if (findingsIndexExists) return 'indexed';
  if (installedIntegrations === 0) return 'not-installed';
  if (healthyAgents === 0) return 'not-deployed';
  if (minutesPassedSinceInstallation <= INDEX_TIMEOUT_IN_MINUTES) return 'indexing';
  if (minutesPassedSinceInstallation > INDEX_TIMEOUT_IN_MINUTES) return 'index-timeout';
  throw new Error('Could not determine csp setup status');
};

const getCspSetupStatus = async (logger, esClient, soClient, packageService, packagePolicyService, agentPolicyService, agentService) => {
  const [findingsIndexExists, installationPackageInfo, latestPackageInfo, installedIntegrations] = await Promise.all([(0, _is_latest_findings_index_exists.isLatestFindingsIndexExists)(esClient, logger), packageService.asInternalUser.getInstallation(_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME), packageService.asInternalUser.fetchFindLatestPackage(_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME), (0, _fleet_util.getCspPackagePolicies)(soClient, packagePolicyService, _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME, {
    per_page: 10000
  })]);
  const healthyAgents = await getHealthyAgents(soClient, installedIntegrations.items, agentPolicyService, agentService);
  const installedIntegrationsTotal = installedIntegrations.total;
  const latestPackageVersion = latestPackageInfo.version;
  const status = getStatus(findingsIndexExists, installedIntegrationsTotal, healthyAgents, getMinutesPassedSinceMoment((installationPackageInfo === null || installationPackageInfo === void 0 ? void 0 : installationPackageInfo.install_started_at) || 0));
  if (status === 'not-installed') return {
    status,
    latestPackageVersion,
    healthyAgents,
    installedIntegrations: installedIntegrationsTotal
  };
  return {
    status,
    latestPackageVersion,
    healthyAgents,
    installedIntegrations: installedIntegrationsTotal,
    installedPackageVersion: installationPackageInfo === null || installationPackageInfo === void 0 ? void 0 : installationPackageInfo.install_version
  };
};

const defineGetCspSetupStatusRoute = router => router.get({
  path: _constants.STATUS_ROUTE_PATH,
  validate: false,
  options: {
    tags: ['access:cloud-security-posture-read']
  }
}, async (context, _, response) => {
  const cspContext = await context.csp;

  try {
    const cspSetupStatus = await getCspSetupStatus(cspContext.logger, cspContext.esClient.asCurrentUser, cspContext.soClient, cspContext.packageService, cspContext.packagePolicyService, cspContext.agentPolicyService, cspContext.agentService);
    const body = cspSetupStatus;
    return response.ok({
      body
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Error while fetching status: ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});

exports.defineGetCspSetupStatusRoute = defineGetCspSetupStatusRoute;