"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimeConnectorFeatureId = exports.UptimeConnectorFeature = exports.SecuritySolutionFeature = exports.SecurityConnectorFeatureId = exports.CasesConnectorFeatureId = exports.CasesConnectorFeature = exports.AlertingConnectorFeatureId = exports.AlertingConnectorFeature = void 0;
exports.areValidFeatures = areValidFeatures;
exports.getConnectorFeatureName = getConnectorFeatureName;

var _i18n = require("@kbn/i18n");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertingConnectorFeatureId = 'alerting';
exports.AlertingConnectorFeatureId = AlertingConnectorFeatureId;
const CasesConnectorFeatureId = 'cases';
exports.CasesConnectorFeatureId = CasesConnectorFeatureId;
const UptimeConnectorFeatureId = 'uptime';
exports.UptimeConnectorFeatureId = UptimeConnectorFeatureId;
const SecurityConnectorFeatureId = 'siem';
exports.SecurityConnectorFeatureId = SecurityConnectorFeatureId;
const AlertingConnectorFeature = {
  id: AlertingConnectorFeatureId,
  name: _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.alerting', {
    defaultMessage: 'Alerting'
  })
};
exports.AlertingConnectorFeature = AlertingConnectorFeature;
const CasesConnectorFeature = {
  id: CasesConnectorFeatureId,
  name: _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.cases', {
    defaultMessage: 'Cases'
  })
};
exports.CasesConnectorFeature = CasesConnectorFeature;
const UptimeConnectorFeature = {
  id: UptimeConnectorFeatureId,
  name: _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.uptime', {
    defaultMessage: 'Uptime'
  })
};
exports.UptimeConnectorFeature = UptimeConnectorFeature;
const SecuritySolutionFeature = {
  id: SecurityConnectorFeatureId,
  name: _i18n.i18n.translate('xpack.actions.availableConnectorFeatures.securitySolution', {
    defaultMessage: 'Security Solution'
  })
};
exports.SecuritySolutionFeature = SecuritySolutionFeature;
const AllAvailableConnectorFeatures = [AlertingConnectorFeature, CasesConnectorFeature, UptimeConnectorFeature, SecuritySolutionFeature];

function areValidFeatures(ids) {
  return ids.every(id => !!AllAvailableConnectorFeatures.find(config => config.id === id));
}

function getConnectorFeatureName(id) {
  const featureConfig = AllAvailableConnectorFeatures.find(config => config.id === id);
  return featureConfig ? featureConfig.name : id;
}