(window.unifiedSearch_bundle_jsonpfunction=window.unifiedSearch_bundle_jsonpfunction||[]).push([[14],{124:function(e,n,a){"use strict";a.r(n),a.d(n,"initialSection",(function(){return r})),a.d(n,"comparisonOperators",(function(){return o})),a.d(n,"logicalOperators",(function(){return l})),a.d(n,"mathOperators",(function(){return d})),a.d(n,"aggregateFunctions",(function(){return u})),a(1);var t=a(3),i=a(8),s=a(0);const r=Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.markdown",{defaultMessage:"## How it works\n\nWith Elasticsearch SQL, you can access that full text search, \nblazing speed, and effortless scalability with a familiar query syntax.\nYou can use SQL to search and aggregate data natively inside Elasticsearch. \nOne can think of Elasticsearch SQL as a translator, \none that understands both SQL and Elasticsearch and makes it easy\nto read and process data in real-time.\n                    \nAn example SQL query can be:\n                    \n```\nSELECT * FROM library \nORDER BY page_count DESC LIMIT 5\n```\n                    \nAs a general rule, Elasticsearch SQL as the name indicates provides a SQL interface to Elasticsearch.\nAs such, it follows the SQL terminology and conventions first, whenever possible.\n                    \nElasticsearch SQL currently accepts only one command at a time. A command is a sequence of tokens terminated by the end of input stream.\n                    \nElasticsearch SQL provides a comprehensive set of built-in operators and functions.\n                    \n                                      "})}),o={label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.comparisonOperators",{defaultMessage:"Comparison operators"}),description:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.comparisonOperatorsDocumentationDescription",{defaultMessage:"Boolean operator for comparing against one or multiple expressions."}),items:[{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.equality",{defaultMessage:"Equality"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.equality.markdown",{defaultMessage:'### Equality (=)\n```\nSELECT last_name l FROM "test_emp" \nWHERE emp_no = 10000 LIMIT 5\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.nullSafeEquality",{defaultMessage:"Null safe equality (<=>)"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.nullSafeEquality.markdown",{defaultMessage:'### Null safe equality:\n```\nSELECT \'elastic\' <=> null AS "equals"\n\n    equals\n---------------\nfalse\n```\n```\nSELECT null <=> null AS "equals"\n\n    equals\n---------------\ntrue\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.inequality",{defaultMessage:"Inequality"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.inequality.markdown",{defaultMessage:'### Inequality (<> or !=)\n```\nSELECT last_name l FROM "test_emp" \nWHERE emp_no <> 10000 ORDER BY emp_no LIMIT 5\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.comparison",{defaultMessage:"Comparison"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.comparison.markdown",{defaultMessage:'### Comparison (<, <=, >, >=)\n```\nSELECT last_name l FROM "test_emp" \nWHERE emp_no < 10003 ORDER BY emp_no LIMIT 5\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.between",{defaultMessage:"Between"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.between.markdown",{defaultMessage:'### Between\n```\nSELECT last_name l FROM "test_emp" \nWHERE emp_no BETWEEN 9990 AND 10003 ORDER BY emp_no\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.nullNotNull",{defaultMessage:"IS NULL and IS NOT NULL"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.nullNotNull.markdown",{defaultMessage:'### IS NULL/IS NOT NULL\n```\nSELECT last_name l FROM "test_emp" \nWHERE emp_no IS NOT NULL AND gender IS NULL\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.inOperator",{defaultMessage:"IN"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.inOperator.markdown",{defaultMessage:'### IN (<value1>, <value2>, ...)\n```\nSELECT last_name l FROM "test_emp" \nWHERE emp_no IN (10000, 10001, 10002, 999) ORDER BY emp_no LIMIT 5\n```\n            ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})}]},l={label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.logicalOperators",{defaultMessage:"Logical operators"}),description:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.logicalOperatorsDocumentationDescription",{defaultMessage:"Boolean operator for evaluating one or two expressions."}),items:[{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.AndOperator",{defaultMessage:"AND"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.andOperator.markdown",{defaultMessage:'### AND\n```\nSELECT last_name l FROM "test_emp" \nWHERE emp_no > 10000 AND emp_no < 10005 ORDER BY emp_no LIMIT 5\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.OrOperator",{defaultMessage:"OR"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.orOperator.markdown",{defaultMessage:'### OR\n```\nSELECT last_name l FROM "test_emp" \nWHERE emp_no < 10003 OR emp_no = 10005 ORDER BY emp_no LIMIT 5\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.NotOperator",{defaultMessage:"NOT"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.notOperator.markdown",{defaultMessage:'### NOT\n```\nSELECT last_name l FROM "test_emp" \nWHERE NOT emp_no = 10000 LIMIT 5\n```\n              ',description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})}]},d={label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.mathOperators",{defaultMessage:"Math operators"}),description:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.mathOperatorsDocumentationDescription",{defaultMessage:"Perform mathematical operations affecting one or two values. The result is a value of numeric type.."}),items:[{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.AddOperator",{defaultMessage:"Add"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.addOperator.markdown",{defaultMessage:"### Add (+)\n```\nSELECT 1 + 1 AS x\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.SubtractOperator",{defaultMessage:"Subtract"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.subtractOperator.markdown",{defaultMessage:"### Subtract (infix -)\n```\nSELECT 1 - 1 AS x\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.negateOperator",{defaultMessage:"Negate"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.negateOperator.markdown",{defaultMessage:"### Negate (unary -)\n```\nSELECT - 1 AS x\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.multiplyOperator",{defaultMessage:"Multiply"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.multiplyOperator.markdown",{defaultMessage:"### Multiply (*)\n```\nSELECT 2 * 3 AS x\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.divideOperator",{defaultMessage:"Divide"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.divideOperator.markdown",{defaultMessage:"### Divide (/)\n```\nSELECT 6 / 3 AS x\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.moduloOperator",{defaultMessage:"Modulo or remainder"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.moduloOperator.markdown",{defaultMessage:"### Modulo or remainder(%)\n```\nSELECT 5 % 2 AS x\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})}]},u={label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.aggregateFunctions",{defaultMessage:"Aggregate functions"}),description:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.aggregateFunctionsDocumentationDescription",{defaultMessage:"Functions for computing a single result from a set of input values. Elasticsearch SQL supports aggregate functions only alongside grouping (implicit or explicit)."}),items:[{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.averageFunction",{defaultMessage:"Average"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.averageFunction.markdown",{defaultMessage:"### AVG\nReturns the Average (arithmetic mean) of input values.\n```\nAVG(numeric_field)\n```\n- numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n```\nSELECT AVG(salary) AS avg FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.countFunction",{defaultMessage:"Count"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.countFunction.markdown",{defaultMessage:"### Count\nReturns the total number (count) of input values.\n\n\n```\nCOUNT(expression)\n```\n- expression. a field name, wildcard (*) or any numeric value. For COUNT(*) or COUNT(<literal>), all values are considered, including null or missing ones. For COUNT(<field_name>), null values are not considered.\n```\nSELECT COUNT(*) AS count FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.countAllFunction",{defaultMessage:"Count (All)"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.countAllFunction.markdown",{defaultMessage:"### Count (All)\nReturns the total number (count) of all non-null input values. COUNT(<field_name>) and COUNT(ALL <field_name>) are equivalent.\n\n```\nCOUNT(ALL field_name) \n```\n- a field name. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n```\nSELECT COUNT(ALL last_name) AS count_all, COUNT(DISTINCT last_name) count_distinct FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.countDistinctFunction",{defaultMessage:"Count (Distinct)"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.countDistinctFunction.markdown",{defaultMessage:"### Count (Distinct)\nReturns the total number of distinct non-null values in input values.\n\n```\nCOUNT(DISTINCT field_name)\n```\n- Input: a field name.\n- Output: numeric value. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n```\nSELECT COUNT(DISTINCT hire_date) unique_hires, COUNT(hire_date) AS hires FROM emp\n\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.firstFunction",{defaultMessage:"First / First_value"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.firstFunction.markdown",{defaultMessage:"### FIRST / FIRST_VALUE\nReturns the first non-null value (if such exists) of the field_name input column sorted by the ordering_field_name column. If ordering_field_name is not provided, only the field_name column is used for the sorting. \n\n```\nFIRST(\n  field_name               \n  [, ordering_field_name])\n```\n- field name: target field for the aggregation\n- ordering_field_name: optional field used for ordering.\n\n```\nSELECT gender, FIRST(first_name, birth_date) FROM emp GROUP BY gender ORDER BY gender\n```\n\n- FIRST cannot be used in a HAVING clause.\n- FIRST cannot be used with columns of type text unless the field is also saved as a keyword.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.lastFunction",{defaultMessage:"Last / Last_value"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.lastFunction.markdown",{defaultMessage:"### LAST / LAST_VALUE\nIt is the inverse of FIRST/FIRST_VALUE. Returns the last non-null value (if such exists) of the field_name input column sorted descending by the ordering_field_name column. If ordering_field_name is not provided, only the field_name column is used for the sorting.  \n\n```\nLAST(\n  field_name               \n  [, ordering_field_name])\n```\n- field name: target field for the aggregation\n- ordering_field_name: optional field used for ordering.\n```\nSELECT gender, LAST(first_name) FROM emp GROUP BY gender ORDER BY gender\n```\n- LAST cannot be used in a HAVING clause.\n- LAST cannot be used with columns of type text unless the field is also saved as a keyword.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.maxFunction",{defaultMessage:"Max"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.maxFunction.markdown",{defaultMessage:"### MAX\nReturns the maximum value across input values in the field field_name.\n\n```\nMAX(field_name) \n```\n- a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MAX(salary) AS max FROM emp\n```\n\n- MAX on a field of type text or keyword is translated into FIRST/FIRST_VALUE and therefore, it cannot be used in HAVING clause.\n\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.minFunction",{defaultMessage:"Min"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.minFunction.markdown",{defaultMessage:"### MIN\nReturns the minimum value across input values in the field field_name.\n\n```\nMIN(field_name) \n```\n- a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MIN(salary) AS min FROM emp\n```\n\n- MIN on a field of type text or keyword is translated into FIRST/FIRST_VALUE and therefore, it cannot be used in HAVING clause.\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.sumFunction",{defaultMessage:"Sum"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.sumFunction.markdown",{defaultMessage:"### SUM\nReturns the sum of input values in the field field_name.\n\n```\nSUM(field_name) \n```\n- a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT SUM(salary) AS sum FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.kurtosisFunction",{defaultMessage:"Kurtosis"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.kurtosisFunction.markdown",{defaultMessage:"### KURTOSIS\nQuantify the shape of the distribution of input values in the field field_name.\n\n```\nKURTOSIS(field_name) \n```\n- a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MIN(salary) AS min, MAX(salary) AS max, KURTOSIS(salary) AS k FROM emp\n```\n\n- KURTOSIS cannot be used on top of scalar functions or operators but only directly on a field. \n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.madFunction",{defaultMessage:"Mad"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.madFunction.markdown",{defaultMessage:"### MAD\nMeasure the variability of the input values in the field field_name.\n\n```\nMAD(field_name) \n```\n- a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MIN(salary) AS min, MAX(salary) AS max, AVG(salary) AS avg, MAD(salary) AS mad FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.percentileFunction",{defaultMessage:"Percentile"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.percentileFunction.markdown",{defaultMessage:"### PERCENTILE\nReturns the nth percentile (represented by numeric_exp parameter) of input values in the field field_name.\n\n```\nPERCENTILE(\n  field_name,         \n  percentile[,        \n  method[,            \n  method_parameter]])\n```\n- field_name : a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n- percentile : a numeric expression (must be a constant and not based on a field). If null, the function returns null.\n- method : optional string literal for the percentile algorithm. Possible values: tdigest or hdr. Defaults to tdigest.\n- method_parameter : optional numeric literal that configures the percentile algorithm. Configures compression for tdigest or number_of_significant_value_digits for hdr. The default is the same as that of the backing algorithm.\n\n```\nSELECT\n    languages,\n    PERCENTILE(salary, 97.3, 'tdigest', 100.0) AS \"97.3_TDigest\",\n    PERCENTILE(salary, 97.3, 'hdr', 3) AS \"97.3_HDR\"\nFROM emp\nGROUP BY languages\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.percentileRankFunction",{defaultMessage:"Percentile rank"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.percentileRankFunction.markdown",{defaultMessage:"### PERCENTILE_RANK\nReturns the nth percentile rank (represented by numeric_exp parameter) of input values in the field field_name.\n\n```\nPERCENTILE_RANK(\n  field_name,         \n  value[,             \n  method[,            \n  method_parameter]]) \n```\n- field_name : a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n- percentile : a numeric expression (must be a constant and not based on a field). If null, the function returns null.\n- method : optional string literal for the percentile algorithm. Possible values: tdigest or hdr. Defaults to tdigest.\n- method_parameter : optional numeric literal that configures the percentile algorithm. Configures compression for tdigest or number_of_significant_value_digits for hdr. The default is the same as that of the backing algorithm.\n\n```\nSELECT\n    languages,\n    ROUND(PERCENTILE_RANK(salary, 65000, 'tdigest', 100.0), 2) AS \"rank_TDigest\",\n    ROUND(PERCENTILE_RANK(salary, 65000, 'hdr', 3), 2) AS \"rank_HDR\"\nFROM emp\nGROUP BY languages\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.skewnessFunction",{defaultMessage:"Skewness"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.skewnessFunction.markdown",{defaultMessage:"### SKEWNESS\nQuantify the asymmetric distribution of input values in the field field_name.\n\n```\nSKEWNESS(field_name) \n```\n- field_name : a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MIN(salary) AS min, MAX(salary) AS max, SKEWNESS(salary) AS s FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.stsdevpopFunction",{defaultMessage:"STDDEV_POP"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.stsdevpopFunction.markdown",{defaultMessage:"### STDDEV_POP\nReturns the population standard deviation of input values in the field field_name.\n\n```\nSTDDEV_POP(field_name) \n```\n- field_name : a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MIN(salary) AS min, MAX(salary) AS max, STDDEV_POP(salary) AS stddev FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.stsdevsampFunction",{defaultMessage:"STDDEV_SAMP"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.stsdevsampFunction.markdown",{defaultMessage:"### STDDEV_SAMP\nReturns the sample standard deviation of input values in the field field_name.\n\n```\nSTDDEV_SAMP(field_name) \n```\n- field_name : a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MIN(salary) AS min, MAX(salary) AS max, STDDEV_SAMP(salary) AS stddev FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.sumofsquaresFunction",{defaultMessage:"Sum of squares"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.sumofsquaresFunction.markdown",{defaultMessage:"### SUM_OF_SQUARES\nReturns the sum of squares of input values in the field field_name.\n\n```\nSUM_OF_SQUARES(field_name) \n```\n- field_name : a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MIN(salary) AS min, MAX(salary) AS max, SUM_OF_SQUARES(salary) AS sumsq\n       FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.varpopFunction",{defaultMessage:"VAR_POP"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.varpopFunction.markdown",{defaultMessage:"### VAR_POP\nReturns the population variance of input values in the field field_name.\n\n```\nVAR_POP(field_name) \n```\n- field_name : a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MIN(salary) AS min, MAX(salary) AS max, VAR_POP(salary) AS varpop FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})},{label:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.varsampFunction",{defaultMessage:"VAR_SAMP"}),description:Object(s.jsx)(i.Markdown,{markdown:t.i18n.translate("unifiedSearch.query.textBasedLanguagesEditor.documentation.varsampFunction.markdown",{defaultMessage:"### VAR_SAMP\nReturns the sample variance of input values in the field field_name.\n\n```\nVAR_SAMP(field_name) \n```\n- field_name : a numeric field. If this field contains only null values, the function returns null. Otherwise, the function ignores null values in this field.\n\n```\nSELECT MIN(salary) AS min, MAX(salary) AS max, VAR_SAMP(salary) AS varsamp FROM emp\n```\n              ",description:"Text is in markdown. Do not translate function names, special characters, or field names like sum(bytes)"})})}]}}}]);