"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Basic = Basic;

var _react = _interopRequireDefault(require("react"));

var _eui = require("@elastic/eui");

var _components = require("../../../components");

var _helpers = require("../../../helpers");

var _use_field = require("../use_field");

var _use_array = require("../use_array");

var _form_utils = require("./form_utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const {
  emptyField
} = _helpers.fieldValidators;
const defaultValue = {
  employees: [{
    name: 'John',
    lastName: 'Snow'
  }]
};
const formConfig = {
  defaultValue
};

function Basic() {
  return /*#__PURE__*/_react.default.createElement(_form_utils.FormWrapper, {
    formConfig: formConfig
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, "Employees")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_use_array.UseArray, {
    path: "employees"
  }, ({
    items,
    addItem,
    removeItem
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(({
      id,
      path
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        key: id,
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
        path: `${path}.name`,
        config: {
          label: 'Name',
          validations: [{
            validator: emptyField('A name is required.')
          }]
        },
        component: _components.TextField
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
        path: `${path}.lastName`,
        config: {
          label: 'Last name',
          validations: [{
            validator: emptyField('A last name is required.')
          }]
        },
        component: _components.TextField
      })), items.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "minusInCircle",
        onClick: () => removeItem(id),
        "aria-label": "Remove item"
      })));
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: addItem
    }, "Add employee")));
  })));
}

Basic.storyName = 'Basic';
Basic.parameters = {
  docs: {
    source: {
      code: `
const defaultValue = {
  employees: [
    {
      name: 'John',
      lastName: 'Snow',
    },
  ],
};

const MyFormComponent = () => {
  const { form } = useForm({ defaultValue });

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      <EuiTitle>
        <h2>Employees</h2>
      </EuiTitle>
      <EuiSpacer />
      <UseArray path="employees">
        {({ items, addItem, removeItem }) => {
          return (
            <>
              {items.map(({ id, path }) => {
                return (
                  <EuiFlexGroup key={id} alignItems="center">
                    <EuiFlexItem>
                      <UseField
                        path={\`\${path}.name\`}
                        config={{
                          label: 'Name',
                          validations: [{ validator: emptyField('A name is required.') }],
                        }}
                        component={TextField}
                      />
                    </EuiFlexItem>
                    <EuiFlexItem>
                      <UseField
                        path={\`\${path}.lastName\`}
                        config={{
                          label: 'Last name',
                          validations: [{ validator: emptyField('A last name is required.') }],
                        }}
                        component={TextField}
                      />
                    </EuiFlexItem>
                    {items.length > 1 && (
                      <EuiFlexItem grow={false}>
                        <EuiButtonIcon
                          iconType="minusInCircle"
                          onClick={() => removeItem(id)}
                          aria-label="Remove item"
                        />
                      </EuiFlexItem>
                    )}
                  </EuiFlexGroup>
                );
              })}
              <EuiSpacer size="m" />
              <EuiFlexGroup justifyContent="flexEnd">
                <EuiButtonEmpty onClick={addItem}>Add employee</EuiButtonEmpty>
              </EuiFlexGroup>
            </>
          );
        }}
      </UseArray>
      <EuiSpacer />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
}
      `,
      language: 'tsx'
    }
  }
};