"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalFields = GlobalFields;

var _react = _interopRequireWildcard(require("react"));

var _eui = require("@elastic/eui");

var _components = require("../../../components");

var _hooks = require("../../hooks");

var _form = require("../form");

var _use_multi_fields = require("../use_multi_fields");

var _form_utils = require("./form_utils");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// map of field ids to "<UseField />" props
const globalFields = {
  fieldA: {
    path: 'fieldA',
    defaultValue: 'foo',
    config: {
      label: 'Field A'
    }
  },
  fieldB: {
    path: 'fieldB',
    defaultValue: 123,
    config: {
      label: 'Field B'
    }
  }
};
const FormGlobalFieldsContext = /*#__PURE__*/(0, _react.createContext)({});

const useGlobalFields = () => {
  const ctx = (0, _react.useContext)(FormGlobalFieldsContext);

  if (!ctx) {
    throw new Error('Missing provider');
  }

  return ctx;
};

const FormGlobalFields = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_use_multi_fields.UseMultiFields, {
    fields: globalFields
  }, fields => {
    return /*#__PURE__*/_react.default.createElement(FormGlobalFieldsContext.Provider, {
      value: fields
    }, children);
  });
};

const FormFields = () => {
  const {
    fieldA,
    fieldB
  } = useGlobalFields();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.TextField, {
    field: fieldA
  }), /*#__PURE__*/_react.default.createElement(_components.NumericField, {
    field: fieldB
  }));
};

function GlobalFields() {
  const {
    form
  } = (0, _hooks.useForm)();
  const [areFieldsVisible, setAreFieldsVisible] = (0, _react.useState)(true);
  const [areGlobalPresent, setAreGlobalPresent] = (0, _react.useState)(true);
  return /*#__PURE__*/_react.default.createElement(_form.Form, {
    form: form
  }, areGlobalPresent && /*#__PURE__*/_react.default.createElement(FormGlobalFields, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, "You might need to have global fields in you form that persist their value event when a field unmounts. The recommended pattern is to use a React context along with \"UseMultiFields\""))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), areFieldsVisible && /*#__PURE__*/_react.default.createElement(FormFields, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setAreFieldsVisible(prev => !prev)
  }, "Toggle fields in DOM"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, "Removing fields from DOM (that are connected to globals) will still preserve their value in the form.")))), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setAreGlobalPresent(prev => !prev)
  }, "Toggle globals fields"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, "Removing the global fields from DOM remove their value when sending the form.")))), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => (0, _form_utils.submitForm)(form)
  }, "Send form")));
}

GlobalFields.storyName = 'GlobalFields';
GlobalFields.parameters = {
  docs: {
    source: {
      code: `
// map of field ids to "<UseField />" props
const globalFields = {
  fieldA: {
    path: 'fieldA',
    defaultValue: 'foo',
    config: {
      label: 'Field A',
    },
  },
  fieldB: {
    path: 'fieldB',
    defaultValue: 123,
    config: {
      label: 'Field B',
    },
  },
};

const FormGlobalFieldsContext = createContext(
  {} as {
    fieldA: FieldHook<string>;
    fieldB: FieldHook<number>;
  }
);

const useGlobalFields = () => {
  const ctx = useContext(FormGlobalFieldsContext);
  if (!ctx) {
    throw new Error('Missing provider');
  }
  return ctx;
};

const FormGlobalFields: React.FC = ({ children }) => {
  return (
    <UseMultiFields fields={globalFields}>
      {(fields) => {
        return (
          <FormGlobalFieldsContext.Provider value={fields}>
            {children}
          </FormGlobalFieldsContext.Provider>
        );
      }}
    </UseMultiFields>
  );
};

const FormFields = () => {
  const { fieldA, fieldB } = useGlobalFields();

  return (
    <>
      <TextField field={fieldA} />
      <NumericField field={fieldB} />
    </>
  );
};

const MyFormComponent = () => {
  const { form } = useForm();
  const [areFieldsVisible, setAreFieldsVisible] = useState(true);
  const [areGlobalPresent, setAreGlobalPresent] = useState(true);

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      {areGlobalPresent && (
        <FormGlobalFields>
          <EuiText>
            <p>
              <EuiTextColor color="subdued">
                You might need to have global fields in you form that persist their value event when
                a field unmounts. The recommended pattern is to use a React context along with
                &quot;UseMultiFields&quot;
              </EuiTextColor>
            </p>
          </EuiText>

          <EuiSpacer />

          {areFieldsVisible && <FormFields />}

          <EuiButton onClick={() => setAreFieldsVisible((prev) => !prev)}>
            Toggle fields in DOM
          </EuiButton>
          <EuiText size="s">
            <p>
              <EuiTextColor color="subdued">
                Removing fields from DOM (that are connected to globals) will still preserve their
                value in the form.
              </EuiTextColor>
            </p>
          </EuiText>
        </FormGlobalFields>
      )}
      <div>
        <EuiSpacer />
        <EuiButton onClick={() => setAreGlobalPresent((prev) => !prev)}>
          Toggle globals fields
        </EuiButton>
        <EuiText size="s">
          <p>
            <EuiTextColor color="subdued">
              Removing the global fields from DOM remove their value when sending the form.
            </EuiTextColor>
          </p>
        </EuiText>
      </div>

      <div>
        <EuiSpacer />
        <EuiButton onClick={submitForm}>Send form</EuiButton>
      </div>
    </Form>
  );
};
      `,
      language: 'tsx'
    }
  }
};