"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreSavedObjectsRouteHandlerContext = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classPrivateFieldSet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldSet"));

var _classPrivateFieldGet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldGet"));

function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }

function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }

var _scopedSavedObjectsClient = /*#__PURE__*/new WeakMap();

var _typeRegistry = /*#__PURE__*/new WeakMap();

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Core's `savedObjects` request handler context.
 * @public
 */

/**
 * The {@link SavedObjectsRequestHandlerContext} implementation.
 * @internal
 */
class CoreSavedObjectsRouteHandlerContext {
  constructor(savedObjectsStart, request) {
    _classPrivateFieldInitSpec(this, _scopedSavedObjectsClient, {
      writable: true,
      value: void 0
    });

    _classPrivateFieldInitSpec(this, _typeRegistry, {
      writable: true,
      value: void 0
    });

    (0, _defineProperty2.default)(this, "getClient", options => {
      if (!options) return this.client;
      return this.savedObjectsStart.getScopedClient(this.request, options);
    });
    (0, _defineProperty2.default)(this, "getExporter", client => {
      return this.savedObjectsStart.createExporter(client);
    });
    (0, _defineProperty2.default)(this, "getImporter", client => {
      return this.savedObjectsStart.createImporter(client);
    });
    this.savedObjectsStart = savedObjectsStart;
    this.request = request;
  }

  get client() {
    if ((0, _classPrivateFieldGet2.default)(this, _scopedSavedObjectsClient) == null) {
      (0, _classPrivateFieldSet2.default)(this, _scopedSavedObjectsClient, this.savedObjectsStart.getScopedClient(this.request));
    }

    return (0, _classPrivateFieldGet2.default)(this, _scopedSavedObjectsClient);
  }

  get typeRegistry() {
    if ((0, _classPrivateFieldGet2.default)(this, _typeRegistry) == null) {
      (0, _classPrivateFieldSet2.default)(this, _typeRegistry, this.savedObjectsStart.getTypeRegistry());
    }

    return (0, _classPrivateFieldGet2.default)(this, _typeRegistry);
  }

}

exports.CoreSavedObjectsRouteHandlerContext = CoreSavedObjectsRouteHandlerContext;