"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_EXCEPTION_LIST_SIZE = exports.LIST_URL = exports.LIST_PRIVILEGES_URL = exports.LIST_ITEM_URL = exports.LIST_INDEX = exports.EXCEPTION_LIST_URL = exports.EXCEPTION_LIST_NAMESPACE_AGNOSTIC = exports.EXCEPTION_LIST_NAMESPACE = exports.EXCEPTION_LIST_ITEM_URL = exports.ENDPOINT_TRUSTED_APPS_LIST_NAME = exports.ENDPOINT_TRUSTED_APPS_LIST_ID = exports.ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = exports.ENDPOINT_LIST_URL = exports.ENDPOINT_LIST_NAME = exports.ENDPOINT_LIST_ITEM_URL = exports.ENDPOINT_LIST_ID = exports.ENDPOINT_LIST_DESCRIPTION = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = exports.ENDPOINT_EVENT_FILTERS_LIST_NAME = exports.ENDPOINT_EVENT_FILTERS_LIST_ID = exports.ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = exports.ENDPOINT_BLOCKLISTS_LIST_NAME = exports.ENDPOINT_BLOCKLISTS_LIST_ID = exports.ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Value list routes
 */
const LIST_URL = '/api/lists';
exports.LIST_URL = LIST_URL;
const LIST_INDEX = `${LIST_URL}/index`;
exports.LIST_INDEX = LIST_INDEX;
const LIST_ITEM_URL = `${LIST_URL}/items`;
exports.LIST_ITEM_URL = LIST_ITEM_URL;
const LIST_PRIVILEGES_URL = `${LIST_URL}/privileges`;
/**
 * Exception list routes
 */

exports.LIST_PRIVILEGES_URL = LIST_PRIVILEGES_URL;
const EXCEPTION_LIST_URL = '/api/exception_lists';
exports.EXCEPTION_LIST_URL = EXCEPTION_LIST_URL;
const EXCEPTION_LIST_ITEM_URL = '/api/exception_lists/items';
/**
 * Exception list spaces
 */

exports.EXCEPTION_LIST_ITEM_URL = EXCEPTION_LIST_ITEM_URL;
const EXCEPTION_LIST_NAMESPACE_AGNOSTIC = 'exception-list-agnostic';
exports.EXCEPTION_LIST_NAMESPACE_AGNOSTIC = EXCEPTION_LIST_NAMESPACE_AGNOSTIC;
const EXCEPTION_LIST_NAMESPACE = 'exception-list';
/**
 * Specific routes for the single global space agnostic endpoint list
 */

exports.EXCEPTION_LIST_NAMESPACE = EXCEPTION_LIST_NAMESPACE;
const ENDPOINT_LIST_URL = '/api/endpoint_list';
/**
 * Specific routes for the single global space agnostic endpoint list. These are convenience
 * routes where they are going to try and create the global space agnostic endpoint list if it
 * does not exist yet or if it was deleted at some point and re-create it before adding items to
 * the list
 */

exports.ENDPOINT_LIST_URL = ENDPOINT_LIST_URL;
const ENDPOINT_LIST_ITEM_URL = '/api/endpoint_list/items';
/**
 * This ID is used for _both_ the Saved Object ID and for the list_id
 * for the single global space agnostic endpoint list
 */

exports.ENDPOINT_LIST_ITEM_URL = ENDPOINT_LIST_ITEM_URL;
const ENDPOINT_LIST_ID = 'endpoint_list';
/** The name of the single global space agnostic endpoint list */

exports.ENDPOINT_LIST_ID = ENDPOINT_LIST_ID;
const ENDPOINT_LIST_NAME = 'Endpoint Security Exception List';
/** The description of the single global space agnostic endpoint list */

exports.ENDPOINT_LIST_NAME = ENDPOINT_LIST_NAME;
const ENDPOINT_LIST_DESCRIPTION = 'Endpoint Security Exception List';
exports.ENDPOINT_LIST_DESCRIPTION = ENDPOINT_LIST_DESCRIPTION;
const MAX_EXCEPTION_LIST_SIZE = 10000;
/** ID of trusted apps agnostic list */

exports.MAX_EXCEPTION_LIST_SIZE = MAX_EXCEPTION_LIST_SIZE;
const ENDPOINT_TRUSTED_APPS_LIST_ID = 'endpoint_trusted_apps';
/** Name of trusted apps agnostic list */

exports.ENDPOINT_TRUSTED_APPS_LIST_ID = ENDPOINT_TRUSTED_APPS_LIST_ID;
const ENDPOINT_TRUSTED_APPS_LIST_NAME = 'Endpoint Security Trusted Apps List';
/** Description of trusted apps agnostic list */

exports.ENDPOINT_TRUSTED_APPS_LIST_NAME = ENDPOINT_TRUSTED_APPS_LIST_NAME;
const ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = 'Endpoint Security Trusted Apps List';
/** ID of event filters agnostic list */

exports.ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION;
const ENDPOINT_EVENT_FILTERS_LIST_ID = 'endpoint_event_filters';
/** Name of event filters agnostic list */

exports.ENDPOINT_EVENT_FILTERS_LIST_ID = ENDPOINT_EVENT_FILTERS_LIST_ID;
const ENDPOINT_EVENT_FILTERS_LIST_NAME = 'Endpoint Security Event Filters List';
/** Description of event filters agnostic list */

exports.ENDPOINT_EVENT_FILTERS_LIST_NAME = ENDPOINT_EVENT_FILTERS_LIST_NAME;
const ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = 'Endpoint Security Event Filters List';
exports.ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION;
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = 'endpoint_host_isolation_exceptions';
exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID;
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = 'Endpoint Security Host isolation exceptions List';
exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME;
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = 'Endpoint Security Host isolation exceptions List';
exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION;
const ENDPOINT_BLOCKLISTS_LIST_ID = 'endpoint_blocklists';
exports.ENDPOINT_BLOCKLISTS_LIST_ID = ENDPOINT_BLOCKLISTS_LIST_ID;
const ENDPOINT_BLOCKLISTS_LIST_NAME = 'Endpoint Security Blocklists List';
exports.ENDPOINT_BLOCKLISTS_LIST_NAME = ENDPOINT_BLOCKLISTS_LIST_NAME;
const ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION = 'Endpoint Security Blocklists List';
exports.ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION = ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION;