/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';

/**
 * Types the DefaultArray<C> as:
 *   - If undefined, then a default array will be set
 *   - If an array is sent in, then the array will be validated to ensure all elements are type C
 */
export var DefaultArray = function DefaultArray(codec) {
  var arrType = t.array(codec);
  return new t.Type('DefaultArray', arrType.is, function (input, context) {
    return input == null ? t.success([]) : arrType.validate(input, context);
  }, t.identity);
};