"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.numberValidator = numberValidator;

var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Validate if a number is greater than a specified minimum & lesser than specified maximum
 */
function numberValidator(conditions) {
  if ((conditions === null || conditions === void 0 ? void 0 : conditions.min) !== undefined && conditions.max !== undefined && conditions.min > conditions.max) {
    throw new Error('Invalid validator conditions');
  }

  return value => {
    const result = {};

    if ((conditions === null || conditions === void 0 ? void 0 : conditions.min) !== undefined && value < conditions.min) {
      result.min = true;
    }

    if ((conditions === null || conditions === void 0 ? void 0 : conditions.max) !== undefined && value > conditions.max) {
      result.max = true;
    }

    if (!!(conditions !== null && conditions !== void 0 && conditions.integerOnly) && !Number.isInteger(value)) {
      result.integerOnly = true;
    }

    if ((0, _mlIsPopulatedObject.isPopulatedObject)(result)) {
      return result;
    }

    return null;
  };
}