/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { PathReporter } from 'io-ts/lib/PathReporter';
import { schema } from '@kbn/config-schema';
import { isLeft } from 'fp-ts/lib/Either';
export function propsToSchema(type) {
  return schema.object({}, {
    unknowns: 'allow',
    validate: function validate(val) {
      var decoded = type.decode(val);

      if (isLeft(decoded)) {
        return PathReporter.report(decoded).join('\n');
      }
    }
  });
}