/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import moment from 'moment';
import { keys } from 'lodash';
export function convertRangeFilterToTimeRange(filter) {
  var key = keys(filter.query.range)[0];
  var values = filter.query.range[key];
  return {
    from: moment(values.gt || values.gte),
    to: moment(values.lt || values.lte)
  };
}
export function convertRangeFilterToTimeRangeString(filter) {
  var _convertRangeFilterTo = convertRangeFilterToTimeRange(filter),
      from = _convertRangeFilterTo.from,
      to = _convertRangeFilterTo.to;

  return {
    from: from === null || from === void 0 ? void 0 : from.toISOString(),
    to: to === null || to === void 0 ? void 0 : to.toISOString()
  };
}