"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URIType = void 0;

var _typeDetect = _interopRequireDefault(require("type-detect"));

var _internals = require("../internals");

var _type = require("./type");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class URIType extends _type.Type {
  constructor(options = {}) {
    super(_internals.internals.string().uri({
      scheme: options.scheme
    }), options);
  }

  handleError(type, {
    value,
    scheme
  }) {
    switch (type) {
      case 'any.required':
      case 'string.base':
        return `expected value of type [string] but got [${(0, _typeDetect.default)(value)}].`;

      case 'string.uriCustomScheme':
        return `expected URI with scheme [${scheme}].`;

      case 'string.uri':
        return `value must be a valid URI (see RFC 3986).`;
    }
  }

}

exports.URIType = URIType;