"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnvOptions = getEnvOptions;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function getEnvOptions(options = {}) {
  return {
    configs: options.configs || [],
    cliArgs: {
      dev: true,
      silent: false,
      watch: false,
      basePath: false,
      disableOptimizer: true,
      cache: true,
      dist: false,
      oss: false,
      runExamples: false,
      ...(options.cliArgs || {})
    }
  };
}