/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
export var getPaletteRegistry = function getPaletteRegistry() {
  var mockPalette1 = {
    id: 'default',
    title: 'My Palette',
    getCategoricalColor: jest.fn(function (_) {
      return 'black';
    }),
    getCategoricalColors: jest.fn(function (num) {
      return ['red', 'black'];
    }),
    toExpression: jest.fn(function () {
      return {
        type: 'expression',
        chain: [{
          type: 'function',
          "function": 'system_palette',
          arguments: {
            name: ['default']
          }
        }]
      };
    })
  };
  var mockPalette2 = {
    id: 'mocked',
    title: 'Mocked Palette',
    getCategoricalColor: jest.fn(function (_) {
      return 'blue';
    }),
    getCategoricalColors: jest.fn(function (num) {
      return ['blue', 'yellow'];
    }),
    toExpression: jest.fn(function () {
      return {
        type: 'expression',
        chain: [{
          type: 'function',
          "function": 'system_palette',
          arguments: {
            name: ['mocked']
          }
        }]
      };
    })
  };
  var mockPalette3 = {
    id: 'custom',
    title: 'Custom Mocked Palette',
    getCategoricalColor: jest.fn(function (_) {
      return 'blue';
    }),
    getCategoricalColors: jest.fn(function (num) {
      return ['blue', 'yellow'];
    }),
    getColorForValue: jest.fn(function (num, state, minMax) {
      return num == null || num < 1 ? undefined : 'blue';
    }),
    canDynamicColoring: true,
    toExpression: jest.fn(function () {
      return {
        type: 'expression',
        chain: [{
          type: 'function',
          "function": 'system_palette',
          arguments: {
            name: ['mocked']
          }
        }]
      };
    })
  };
  return {
    get: function get(name) {
      return name === 'custom' ? mockPalette3 : name !== 'default' ? mockPalette2 : mockPalette1;
    },
    getAll: function getAll() {
      return [mockPalette1, mockPalette2, mockPalette3];
    }
  };
};