import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
export var OptInConfigService = /*#__PURE__*/function () {
  function OptInConfigService(optInConfig) {
    _classCallCheck(this, OptInConfigService);

    this.optInConfig = optInConfig;
  }
  /**
   * Is globally opted in?
   */


  _createClass(OptInConfigService, [{
    key: "isOptedIn",
    value: function isOptedIn() {
      return this.optInConfig.global.enabled;
    }
    /**
     * Is the given event type opted in?
     * @param eventType the event type to check
     */

  }, {
    key: "isEventTypeOptedIn",
    value: function isEventTypeOptedIn(eventType) {
      var _ref, _this$optInConfig$eve;

      if (!this.isOptedIn()) {
        return false;
      } // In case of not provided a specific eventType consent, we assume opted-in


      var isEventTypeOptedIn = (_ref = this.optInConfig.event_types && ((_this$optInConfig$eve = this.optInConfig.event_types[eventType]) === null || _this$optInConfig$eve === void 0 ? void 0 : _this$optInConfig$eve.enabled)) !== null && _ref !== void 0 ? _ref : true;
      return isEventTypeOptedIn;
    }
    /**
     * Is the given shipper opted in?
     * @param shipperName the shipper to check
     * @param eventType the event type to check for the shipper
     */

  }, {
    key: "isShipperOptedIn",
    value: function isShipperOptedIn(shipperName, eventType) {
      var _ref2;

      if (!this.isOptedIn()) {
        return false;
      } // In case of not provided a specific shipper consent, we assume opted-in


      var isShipperGloballyOptedIn = (_ref2 = this.optInConfig.global.shippers && this.optInConfig.global.shippers[shipperName]) !== null && _ref2 !== void 0 ? _ref2 : true;

      if (!isShipperGloballyOptedIn) {
        return false;
      }

      if (eventType) {
        var _ref3;

        if (!this.isEventTypeOptedIn(eventType)) {
          return false;
        }

        var eventTypeOptInConfig = this.optInConfig.event_types && this.optInConfig.event_types[eventType]; // In case of not provided a specific eventType-level shipper consent, we assume opted-in

        var isEventTypeShipperOptedIn = (_ref3 = (eventTypeOptInConfig === null || eventTypeOptInConfig === void 0 ? void 0 : eventTypeOptInConfig.shippers) && eventTypeOptInConfig.shippers[shipperName]) !== null && _ref3 !== void 0 ? _ref3 : true;
        return isEventTypeShipperOptedIn;
      } else {
        return isShipperGloballyOptedIn;
      }
    }
  }]);

  return OptInConfigService;
}();