"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTimelineItemEvent = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _timeline_item_event = require("./timeline_item_event.styles");

var _react2 = require("@emotion/react");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTimelineItemEvent = function EuiTimelineItemEvent(_ref) {
  var children = _ref.children,
      _ref$verticalAlign = _ref.verticalAlign,
      verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign;
  var styles = (0, _timeline_item_event.euiTimelineItemEventStyles)();
  var cssStyles = [styles.euiTimelineItemEvent, styles[verticalAlign]];
  return (0, _react2.jsx)("div", {
    css: cssStyles
  }, children);
};

exports.EuiTimelineItemEvent = EuiTimelineItemEvent;
EuiTimelineItemEvent.propTypes = {
  /**
     * Accepts any node. But preferably `EuiPanel`
     */
  children: _propTypes.default.node.isRequired,
  verticalAlign: _propTypes.default.any
};