"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiLoadingContent = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _loading_strings = require("./_loading_strings");

var _loading_content = require("./loading_content.styles");

var _react2 = require("@emotion/react");

var _excluded = ["lines", "className", "aria-label"];

var EuiLoadingContent = function EuiLoadingContent(_ref) {
  var _ref$lines = _ref.lines,
      lines = _ref$lines === void 0 ? 3 : _ref$lines,
      className = _ref.className,
      ariaLabel = _ref['aria-label'],
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _loading_content.euiLoadingContentStyles)(euiTheme);
  var lineCssStyles = [styles.euiLoadingContent__singleLine];
  var defaultLabel = (0, _loading_strings.useLoadingAriaLabel)();
  var classes = (0, _classnames.default)('euiLoadingContent', className);
  var lineElements = [];

  for (var i = 0; i < lines; i++) {
    lineElements.push((0, _react2.jsx)("span", {
      key: i,
      css: lineCssStyles
    }));
  }

  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest), lineElements);
};

exports.EuiLoadingContent = EuiLoadingContent;
EuiLoadingContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  lines: _propTypes.default.oneOf([1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
};