"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEXT_SIZES = exports.EuiHealth = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _health = require("./health.styles");

var _icon = require("../icon");

var _flex = require("../flex");

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "color", "textSize"];
var TEXT_SIZES = ['xs', 's', 'm', 'inherit'];
exports.TEXT_SIZES = TEXT_SIZES;

var EuiHealth = function EuiHealth(_ref) {
  var children = _ref.children,
      className = _ref.className,
      color = _ref.color,
      _ref$textSize = _ref.textSize,
      textSize = _ref$textSize === void 0 ? 's' : _ref$textSize,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _health.euiHealthStyles)(euiTheme);
  var cssStyles = [styles.euiHealth, styles[textSize]];
  var classes = (0, _classnames.default)('euiHealth', className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "dot",
    color: color
  })), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, children)));
};

exports.EuiHealth = EuiHealth;
EuiHealth.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Sets the color of the dot icon.
       * It accepts any `IconColor`: `default`, `primary`, `success`, `accent`, `warning`, `danger`, `text`,
       * `subdued` or `ghost`; or any valid CSS color value as a `string`
       */
  color: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.any.isRequired]),

  /**
       * Matches the text scales of EuiText.
       * The `inherit` style will get its font size from the parent element
       */
  textSize: _propTypes.default.any
};