"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDescribedFormGroup = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _title = require("../../title");

var _text = require("../../text");

var _flex = require("../../flex");

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "gutterSize", "fullWidth", "ratio", "titleSize", "title", "description", "descriptionFlexItemProps", "fieldFlexItemProps"];

var EuiDescribedFormGroup = function EuiDescribedFormGroup(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      _ref$ratio = _ref.ratio,
      ratio = _ref$ratio === void 0 ? 'half' : _ref$ratio,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'xs' : _ref$titleSize,
      title = _ref.title,
      description = _ref.description,
      descriptionFlexItemProps = _ref.descriptionFlexItemProps,
      fieldFlexItemProps = _ref.fieldFlexItemProps,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiDescribedFormGroup', {
    'euiDescribedFormGroup--fullWidth': fullWidth
  }, className);
  var fieldClasses = (0, _classnames.default)('euiDescribedFormGroup__fields', fieldFlexItemProps && fieldFlexItemProps.className);
  var renderedDescription;

  if (description) {
    // If the description is just a string, wrap it in a paragraph element
    if (typeof description === 'string') {
      description = (0, _react2.jsx)("p", null, description);
    }

    renderedDescription = (0, _react2.jsx)(_text.EuiText, {
      size: "s",
      color: "subdued",
      className: "euiDescribedFormGroup__description"
    }, description);
  }

  var fieldGrowth;

  switch (ratio) {
    case 'half':
      fieldGrowth = 1;
      break;

    case 'third':
      fieldGrowth = 2;
      break;

    case 'quarter':
      fieldGrowth = 3;
      break;

    default:
      console.warn('Please provide an allowed ratio to EuiDescribedFromRow');
      break;
  }

  return (0, _react2.jsx)("div", (0, _extends2.default)({
    role: "group",
    className: classes
  }, rest), (0, _react2.jsx)(_flex.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: gutterSize
  }, (0, _react2.jsx)(_flex.EuiFlexItem, (0, _extends2.default)({
    grow: 1
  }, descriptionFlexItemProps, {
    className: (0, _classnames.default)('euiDescribedFormGroup__descriptionColumn', descriptionFlexItemProps === null || descriptionFlexItemProps === void 0 ? void 0 : descriptionFlexItemProps.className)
  }), (0, _react2.jsx)(_title.EuiTitle, {
    size: titleSize,
    className: "euiDescribedFormGroup__title"
  }, title), renderedDescription), (0, _react2.jsx)(_flex.EuiFlexItem, (0, _extends2.default)({
    grow: fieldGrowth
  }, fieldFlexItemProps, {
    className: fieldClasses
  }), children)));
};

exports.EuiDescribedFormGroup = EuiDescribedFormGroup;
EuiDescribedFormGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * One or more `EuiFormRow`s.
       */
  children: _propTypes.default.node,

  /**
       * Passed to `EuiFlexGroup`.
       */
  gutterSize: _propTypes.default.oneOf(["none", "xs", "s", "m", "l", "xl"]),

  /**
       * Expand to fill 100% of the parent.
       * Default max-width is 800px.
       */
  fullWidth: _propTypes.default.bool,

  /**
       * Width ratio of description column compared to field column.
       * Can be used in conjunction with `fullWidth` and
       * may require `fullWidth` to be applied to child elements.
       */
  ratio: _propTypes.default.oneOf(["half", "third", "quarter"]),

  /**
       * For better accessibility, it's recommended to use an HTML heading.
       */
  title: _propTypes.default.element.isRequired,

  /**
       * Adjust the visual `size` of the EuiTitle that wraps `title`.
       */
  titleSize: _propTypes.default.any,

  /**
       * Added as a child of `EuiText`.
       */
  description: _propTypes.default.node,

  /**
       * For customizing the field container. Extended from `EuiFlexItem`.
       */
  descriptionFlexItemProps: _propTypes.default.any,
  fieldFlexItemProps: _propTypes.default.any
};